/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.command.AsyncCommand;
import org.sapia.ubik.rmi.server.command.Command;
import org.sapia.ubik.rmi.server.command.ExecQueue;
import org.sapia.ubik.rmi.server.command.InQueue;
import org.sapia.ubik.rmi.server.command.OutQueue;
import org.sapia.ubik.rmi.server.command.ResponseSender;

public class CommandProcessor {
    private ExecQueue _in;

    public CommandProcessor(int maxThreads) throws IllegalStateException {
        try {
            this._in = new InQueue(maxThreads);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Object processSyncCommand(Command cmd) {
        try {
            return cmd.execute();
        }
        catch (Throwable t) {
            return t;
        }
    }

    public void processAsyncCommand(String cmdId, VmId caller, ServerAddress from, Command cmd) {
        this._in.add(new AsyncCommand(cmdId, caller, from, cmd));
    }

    public void setResponseSender(ResponseSender sender) {
        OutQueue.setResponseSender(sender);
    }

    public void shutdown(long timeout) throws InterruptedException {
        Log.warning(this.getClass(), (Object)"Shutting down incoming command queue");
        this._in.shutdown(timeout);
        Log.warning(this.getClass(), (Object)"Shutting down outgoing response queue");
        OutQueue.shutdownAll(timeout);
    }
}

