/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.sapia.ubik.net.Timer;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.command.Executable;

public class ExecQueue {
    private LinkedList _queue = new LinkedList();
    private boolean _shutdown;

    public synchronized void add(Executable toExecute) {
        if (this._shutdown) {
            throw new ShutdownException();
        }
        this._queue.add(toExecute);
        this.notifyAll();
    }

    public synchronized List removeAll() throws InterruptedException, ShutdownException {
        while (this._queue.size() == 0) {
            if (this._shutdown) {
                this.notify();
                throw new ShutdownException();
            }
            this.wait();
        }
        ArrayList toReturn = new ArrayList(this._queue);
        this._queue.clear();
        return toReturn;
    }

    public synchronized void shutdown(long timeout) throws InterruptedException {
        this._shutdown = true;
        this.notifyAll();
        Timer timer = new Timer(timeout);
        while (this._queue.size() > 0) {
            this.wait(timeout);
            if (!timer.isOver()) continue;
            break;
        }
    }

    public int size() {
        return this._queue.size();
    }

    public synchronized Executable remove() throws InterruptedException, ShutdownException {
        while (this._queue.size() == 0) {
            if (this._shutdown) {
                this.notify();
                throw new ShutdownException();
            }
            this.wait();
        }
        return (Executable)this._queue.remove(0);
    }
}

