/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.ThreadPool;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.command.AsyncCommand;
import org.sapia.ubik.rmi.server.command.Destination;
import org.sapia.ubik.rmi.server.command.ExecQueue;
import org.sapia.ubik.rmi.server.command.OutQueue;
import org.sapia.ubik.rmi.server.command.Response;

public class InQueue
extends ExecQueue {
    CmdProcessorThreadPool _pool;

    InQueue() throws Exception {
        this(1);
    }

    InQueue(int maxThreads) throws Exception {
        if (maxThreads <= 0) {
            maxThreads = 1;
        }
        this._pool = new CmdProcessorThreadPool(maxThreads);
        this._pool.fill(maxThreads);
        for (int count = 0; count < maxThreads; ++count) {
            PooledThread pt = (PooledThread)this._pool.acquire();
            pt.exec(this);
        }
    }

    @Override
    public void shutdown(long timeout) throws InterruptedException {
        super.shutdown(timeout);
        this._pool.shutdown(timeout);
    }

    static class CmdProcessorThreadPool
    extends ThreadPool {
        public CmdProcessorThreadPool(int maxSize) {
            super("ubik.rmi.CallbackThread", true, maxSize);
        }

        @Override
        protected PooledThread newThread() throws Exception {
            return new CmdProcessorThread();
        }
    }

    static class CmdProcessorThread
    extends PooledThread {
        CmdProcessorThread() {
        }

        @Override
        protected void doExec(Object task) {
            InQueue queue = (InQueue)task;
            while (true) {
                try {
                    Object toReturn;
                    AsyncCommand async = (AsyncCommand)queue.remove();
                    try {
                        toReturn = async.execute();
                    }
                    catch (ShutdownException e) {
                        Log.warning(this.getName(), (Object)"Shutting down...");
                        break;
                    }
                    catch (Throwable t) {
                        toReturn = t;
                    }
                    OutQueue.getQueueFor(new Destination(async.getFrom(), async.getCallerVmId())).add(new Response(async.getCmdId(), toReturn));
                    Thread.yield();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        @Override
        protected void handleExecutionException(Exception e) {
            Log.warning(this.getClass(), (Object)"Error executing thread", (Throwable)e);
        }

        @Override
        public void shutdown() {
            Log.warning(this.getName(), (Object)"Shut down signal received...");
            super.shutdown();
        }
    }
}

