/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sapia.ubik.net.Timer;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.command.Destination;
import org.sapia.ubik.rmi.server.command.ExecQueue;
import org.sapia.ubik.rmi.server.command.Executable;
import org.sapia.ubik.rmi.server.command.LocalResponseSender;
import org.sapia.ubik.rmi.server.command.ResponseSender;

public class OutQueue
extends ExecQueue {
    static Map _queuesByHost = Collections.synchronizedMap(new HashMap());
    static ResponseSender _sender = new LocalResponseSender();
    static OutQueueMonitor _monitor = new OutQueueMonitor();
    static boolean _added;

    private OutQueue() {
    }

    public static void shutdownAll(long timeout) throws InterruptedException {
        Iterator queues = _queuesByHost.values().iterator();
        while (queues.hasNext()) {
            ((OutQueue)queues.next()).shutdown(timeout);
        }
        _monitor.shutdown(timeout);
    }

    @Override
    public final void add(Executable cmd) {
        super.add(cmd);
        _monitor.wakeUp();
    }

    public static final synchronized OutQueue getQueueFor(Destination dest) {
        OutQueue out = (OutQueue)_queuesByHost.get(dest);
        if (out == null) {
            out = new OutQueue();
            _queuesByHost.put(dest, out);
        }
        return out;
    }

    static void setResponseSender(ResponseSender s) {
        _sender = s;
    }

    static {
        _monitor.setName("ubik.rmi.outqueue.Monitor");
        _monitor.setDaemon(true);
        _monitor.start();
    }

    static final class OutQueueMonitor
    extends Thread {
        Destination[] hosts;
        OutQueue queue;
        List resps;
        boolean shutdown;
        boolean shutdownRequested;

        OutQueueMonitor() {
        }

        @Override
        public void run() {
            while (true) {
                this.hosts = _queuesByHost.keySet().toArray(new Destination[_queuesByHost.size()]);
                for (int i = 0; i < this.hosts.length; ++i) {
                    this.queue = (OutQueue)_queuesByHost.get(this.hosts[i]);
                    if (this.queue.size() <= 0) continue;
                    try {
                        try {
                            this.resps = this.queue.removeAll();
                        }
                        catch (ShutdownException e) {
                            this.shutdownRequested = true;
                            continue;
                        }
                        if (_sender == null) continue;
                        _sender.sendResponses(this.hosts[i], this.resps);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (this.shutdownRequested) {
                    this.doNotifyShutDown();
                    return;
                }
                Thread.yield();
                try {
                    this.waitAdded();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        synchronized void shutdown(long timeout) throws InterruptedException {
            Timer timer = new Timer(timeout);
            this.shutdownRequested = true;
            this.notify();
            while (!this.shutdown) {
                this.wait(timeout);
                if (!timer.isOver()) continue;
                break;
            }
        }

        private synchronized void doNotifyShutDown() {
            this.shutdown = true;
            this.notifyAll();
        }

        private synchronized void waitAdded() throws InterruptedException {
            while (!_added && !this.shutdownRequested) {
                this.wait();
            }
            _added = false;
        }

        synchronized void wakeUp() {
            _added = true;
            this.notify();
        }
    }
}

