/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import org.sapia.ubik.net.Timer;
import org.sapia.ubik.rmi.server.command.ResponseQueue;
import org.sapia.ubik.rmi.server.command.ResponseTimeOutException;

public class ResponseLock {
    private static int _count = 0;
    private Object _response;
    private ResponseQueue _queue;
    private String _id;
    private boolean _ready;

    ResponseLock(ResponseQueue parent) {
        this._queue = parent;
        this._id = ResponseLock.generateId();
    }

    public String getId() {
        return this._id;
    }

    public void release() {
        this._queue.removeLock(this._id);
    }

    public synchronized Object waitResponse(long timeout) throws InterruptedException, ResponseTimeOutException {
        Timer timer = new Timer(timeout);
        while (!this._ready) {
            this.wait(timeout);
            if (!timer.isOver() || this._ready) continue;
            this.release();
            throw new ResponseTimeOutException();
        }
        this.release();
        return this._response;
    }

    public synchronized void setResponse(Object r) {
        this._response = r;
        this._ready = true;
        this.notify();
    }

    private static synchronized String generateId() {
        if (_count > 999) {
            _count = 0;
        }
        return "" + System.currentTimeMillis() + _count++;
    }
}

