/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sapia.ubik.net.Timer;
import org.sapia.ubik.rmi.server.command.Response;
import org.sapia.ubik.rmi.server.command.ResponseLock;

public class ResponseQueue {
    private static ResponseQueue _instance = new ResponseQueue();
    private Map _responses = Collections.synchronizedMap(new HashMap());
    private boolean _shutdown;

    ResponseQueue() {
    }

    public synchronized ResponseLock createResponseLock() {
        ResponseLock lock = new ResponseLock(this);
        if (this._responses.get(lock.getId()) != null) {
            throw new IllegalStateException("response lock already exists for: " + lock.getId());
        }
        this._responses.put(lock.getId(), lock);
        return lock;
    }

    public void onResponses(List responses) {
        for (int i = 0; i < responses.size(); ++i) {
            Response resp = (Response)responses.get(i);
            ResponseLock lock = (ResponseLock)this._responses.get(resp.getId());
            if (lock == null) continue;
            lock.setResponse(resp.get());
        }
    }

    public synchronized void shutdown(long timeout) throws InterruptedException {
        this._shutdown = true;
        Timer timer = new Timer(timeout);
        while (this._responses.size() > 0) {
            this.wait(timeout);
            if (!timer.isOver()) continue;
            break;
        }
    }

    public int size() {
        return this._responses.size();
    }

    synchronized void removeLock(String id) {
        this._responses.remove(id);
        if (this._shutdown) {
            this.notify();
        }
    }

    public static final ResponseQueue getInstance() {
        return _instance;
    }
}

