/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.gc;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.gc.ClientGCMBean;
import org.sapia.ubik.rmi.server.gc.CommandGc;
import org.sapia.ubik.rmi.server.perf.HitStatFactory;
import org.sapia.ubik.rmi.server.perf.HitsPerHourStatistic;
import org.sapia.ubik.rmi.server.perf.HitsPerMinStatistic;
import org.sapia.ubik.rmi.server.perf.Statistic;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;
import org.sapia.ubik.taskman.TaskManager;

public class ClientGC
implements Task,
ClientGCMBean,
MBeanFactory {
    public static final long GC_CLEAN_INTERVAL = 10000L;
    public static final int GC_CLEAN_SIZE = 1000;
    private long _gcInterval = 10000L;
    private int _gcBatchSize = 1000;
    private Map<ServerAddress, Map<OID, Reference<Object>>> _objByHosts = new ConcurrentHashMap<ServerAddress, Map<OID, Reference<Object>>>();
    private long _lastGlobalPingTime = System.currentTimeMillis();
    private int _threshold;
    private int _lastGcCount;
    private HitsPerMinStatistic _gcRefPerMin;
    private HitsPerMinStatistic _gcDerefPerMin;
    private HitsPerMinStatistic _gcConnectionsPerMin;
    private HitsPerHourStatistic _forcedGcPerHour;
    private Statistic _objectCount = new RemoteObjectCountStat();
    private TaskManager _taskMan;

    public ClientGC(TaskManager taskman) {
        PropUtil props = new PropUtil().addProperties(System.getProperties());
        this._taskMan = taskman;
        this._gcInterval = props.getLongProperty("ubik.rmi.client.gc.interval", 10000L);
        this._gcBatchSize = props.getIntProperty("ubik.rmi.client.gc.batch.size", 1000);
        this._threshold = props.getIntProperty("ubik.rmi.client.gc.threshold", 0);
        this._gcConnectionsPerMin = HitStatFactory.createHitsPerMin("ClientGcConnectionsPerMin", this._gcInterval, Hub.statsCollector);
        this._gcRefPerMin = HitStatFactory.createHitsPerMin("ClientGcRefPerMin", this._gcInterval, Hub.statsCollector);
        this._gcDerefPerMin = HitStatFactory.createHitsPerMin("ClientGcDerefPerMin", this._gcInterval, Hub.statsCollector);
        this._forcedGcPerHour = HitStatFactory.createHitsPerHour("ClientGcForcedPerHour", this._gcInterval, Hub.statsCollector);
        Hub.statsCollector.addStat(this._objectCount);
        this._taskMan.addTask(new TaskContext("UbikRMI.ClientGC", this._gcInterval), this);
        Log.info(this.getClass(), (Object)("Will run every " + this._gcInterval + " ms."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(ServerAddress address, OID oid, Object remote) {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("Registering remote object: " + oid + " from " + address));
        }
        Map<ServerAddress, Map<OID, Reference<Object>>> map = this._objByHosts;
        synchronized (map) {
            Map<OID, Reference<Object>> hostMap = this._objByHosts.get(address);
            if (hostMap == null) {
                hostMap = new ConcurrentHashMap<OID, Reference<Object>>();
                this._objByHosts.put(address, hostMap);
            }
            if (hostMap.containsKey(oid)) {
                return false;
            }
            if (this._gcRefPerMin.isEnabled()) {
                this._gcRefPerMin.hit();
            }
            hostMap.put(oid, new WeakReference<Object>(remote));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(TaskContext ctx) {
        ArrayList<OID> oidsToSend = new ArrayList<OID>(this._gcBatchSize);
        int totalCount = 0;
        int remoteObjectCount = 0;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"running client GC...");
        }
        try {
            Set<ServerAddress> keySet = this._objByHosts.keySet();
            ServerAddress[] addresses = keySet.toArray(new ServerAddress[keySet.size()]);
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("host count: " + addresses.length));
            }
            for (int i = 0; i < addresses.length; ++i) {
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)("host address: " + addresses[i]));
                }
                Map<OID, Reference<Object>> refs = this._objByHosts.get(addresses[i]);
                OID[] oids = refs.keySet().toArray(new OID[refs.size()]);
                remoteObjectCount += refs.size();
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)(addresses[i] + " oids: " + oids.length));
                }
                Map<ServerAddress, Map<OID, Reference<Object>>> map = this._objByHosts;
                synchronized (map) {
                    if (oids.length == 0) {
                        this._objByHosts.remove(addresses[i]);
                        break;
                    }
                }
                boolean sent = true;
                for (int j = 0; j < oids.length; ++j) {
                    Reference<Object> ref = refs.get(oids[j]);
                    if (ref.get() != null) continue;
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)(oids[j] + " is null"));
                    }
                    refs.remove(oids[j]);
                    oidsToSend.add(oids[j]);
                    ++totalCount;
                    if (oidsToSend.size() < this._gcBatchSize) continue;
                    sent = this.doSend(oidsToSend.toArray(new OID[oidsToSend.size()]), oidsToSend.size(), addresses[i]);
                    oidsToSend.clear();
                }
                if (sent) {
                    this.doSend(oidsToSend.toArray(new OID[oidsToSend.size()]), oidsToSend.size(), addresses[i]);
                }
                if (totalCount > 0) {
                    this._lastGcCount = totalCount;
                }
                totalCount = 0;
                if (this._threshold <= 0 || refs.size() < this._threshold) continue;
                this._forcedGcPerHour.hit();
                Runtime.getRuntime().gc();
            }
        }
        finally {
            this._lastGlobalPingTime = System.currentTimeMillis();
        }
    }

    @Override
    public void setBatchSize(int size) {
        this._gcBatchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this._gcBatchSize;
    }

    @Override
    public void setThreshold(int t) {
        this._threshold = t;
    }

    @Override
    public int getThreshold() {
        return this._threshold;
    }

    @Override
    public long getInterval() {
        return this._gcInterval;
    }

    @Override
    public int getRemoteObjectCount() {
        Set<ServerAddress> keySet = this._objByHosts.keySet();
        ServerAddress[] addresses = keySet.toArray(new ServerAddress[keySet.size()]);
        int total = 0;
        for (int i = 0; i < addresses.length; ++i) {
            Map<OID, Reference<Object>> refs = this._objByHosts.get(addresses[i]);
            total += refs.size();
        }
        return total;
    }

    @Override
    public Date getLastPingDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this._lastGlobalPingTime);
        return cal.getTime();
    }

    @Override
    public double getGcPerMin() {
        return this._gcDerefPerMin.getStat();
    }

    @Override
    public double getForcedGcPerHour() {
        return this._forcedGcPerHour.getStat();
    }

    @Override
    public int getLastGcCount() {
        return this._lastGcCount;
    }

    @Override
    public MBeanContainer createMBean() throws Exception {
        ObjectName name = new ObjectName("sapia.ubik.rmi:type=ClientGC");
        return new MBeanContainer(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSend(OID[] toSend, int count, ServerAddress addr) {
        if (count == 0 && System.currentTimeMillis() - this._lastGlobalPingTime < this._gcInterval) {
            Log.info(this.getClass(), (Object)("Skipping Client GC command to " + addr + " bacause interval " + this._gcInterval + " not met"));
            return true;
        }
        Log.info(this.getClass(), (Object)("Sending Client GC command to " + addr));
        RmiConnection conn = null;
        try {
            if (count > 0) {
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)("sending GC command to " + addr + "; cleaning " + count + " objects"));
                }
                if (Log.isInfo()) {
                    for (int i = 0; i < toSend.length; ++i) {
                        Log.info(this.getClass(), (Object)("Dereferencing: " + toSend[i]));
                    }
                }
            } else if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"no garbage; pinging server...");
            }
            conn = TransportManager.getConnectionsFor(addr).acquire();
            if (this._gcConnectionsPerMin.isEnabled()) {
                this._gcDerefPerMin.hit(count);
                this._gcConnectionsPerMin.hit();
            }
            conn.send(new CommandGc(toSend, count));
            conn.receive();
            TransportManager.getConnectionsFor(addr).release(conn);
        }
        catch (Throwable e) {
            if (e instanceof RemoteException) {
                Log.info(ClientGC.class, "Error sending GC command to server " + addr + " - cleaning up corresponding remote objects", e);
                Map<ServerAddress, Map<OID, Reference<Object>>> map = this._objByHosts;
                synchronized (map) {
                    this._objByHosts.remove(addr);
                }
            }
            if (conn != null) {
                conn.close();
            }
            return false;
        }
        for (int k = 0; k < count; ++k) {
            toSend[k] = null;
        }
        return true;
    }

    class RemoteObjectCountStat
    extends Statistic {
        RemoteObjectCountStat() {
            super("ClientGcRemoteObjectCount");
        }

        @Override
        public double getStat() {
            int total = 0;
            for (Map refsForHost : new ArrayList(ClientGC.this._objByHosts.values())) {
                total += refsForHost.size();
            }
            return total;
        }
    }
}

