/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.gc;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.gc.GcEvent;

public class CommandGc
extends RMICommand {
    private int _count;
    private OID[] _oids;

    public CommandGc() {
    }

    CommandGc(OID[] oids, int count) {
        this._oids = oids;
        this._count = count;
    }

    @Override
    public Object execute() throws Throwable {
        int i;
        for (i = 0; i < this._count; ++i) {
            Hub.serverRuntime.gc.dereference(this._vmId, this._oids[i]);
        }
        Hub.serverRuntime.dispatchEvent(new GcEvent(super.getVmId(), super.getServerAddress(), this._count));
        Hub.serverRuntime.gc.touch(this._vmId);
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("cleaned " + i + " objects"));
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._count = in.readInt();
        this._oids = (OID[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._count);
        out.writeObject(this._oids);
    }
}

