/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.gc;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.gc.ServerGCMBean;
import org.sapia.ubik.rmi.server.perf.HitStatFactory;
import org.sapia.ubik.rmi.server.perf.HitsPerMinStatistic;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;
import org.sapia.ubik.taskman.TaskManager;

public class ServerGC
implements Task,
ServerGCMBean,
MBeanFactory {
    public static final long GC_TIMEOUT = 450000L;
    public static final long GC_INTERVAL = 30000L;
    private static long _gcTimeout = 450000L;
    private static long _gcInterval = 30000L;
    private static HitsPerMinStatistic _gcRefPerMin;
    private static HitsPerMinStatistic _gcDerefPerMin;
    private Map<VmId, ClientInfo> _clientTable = new ConcurrentHashMap<VmId, ClientInfo>();

    public ServerGC(TaskManager taskman) {
        PropUtil pu = new PropUtil().addProperties(System.getProperties());
        _gcInterval = pu.getLongProperty("ubik.rmi.server.gc.interval", 30000L);
        _gcTimeout = pu.getLongProperty("ubik.rmi.server.gc.timeout", 450000L);
        if (_gcInterval > 0L) {
            taskman.addTask(new TaskContext("UbikRMI.ServerGC", _gcInterval), this);
        } else {
            Log.warning(this.getClass(), (Object)"Will be disabled; client timeouts will not be monitored");
        }
        _gcRefPerMin = HitStatFactory.createHitsPerMin("ServerGCRefPerMin", 0L, Hub.statsCollector);
        _gcDerefPerMin = HitStatFactory.createHitsPerMin("ServerGCDerefPerMin", 0L, Hub.statsCollector);
    }

    public int getRefCount(VmId id, OID oid) {
        return this.getClientInfo(id).getRefCount(oid);
    }

    public int getSpecificCount(VmId id, OID oid) {
        return this.getClientInfo(id).getSpecificCount(oid);
    }

    public boolean containsClient(VmId id) {
        return this._clientTable.containsKey(id);
    }

    public void reference(VmId id, OID oid) {
        if (Log.isDebug()) {
            Log.debug(ServerGC.class, (Object)("referencing from: " + id + " on object: " + oid));
        }
        _gcRefPerMin.hit();
        ClientInfo inf = this.getClientInfo(id);
        inf.reference(oid);
    }

    public void registerRef(VmId id, OID oid, Object o) {
        if (Log.isInfo()) {
            Log.info(ServerGC.class, (Object)("reference created from: " + id + " on object: " + oid + " - " + o.getClass().getName()));
        }
        _gcRefPerMin.hit();
        ClientInfo inf = this.getClientInfo(id);
        inf.registerRef(oid, o);
    }

    public void dereference(VmId id, OID oid) {
        if (Log.isDebug()) {
            Log.debug(ServerGC.class, (Object)("dereferencing from: " + id + " on object: " + oid));
        }
        _gcDerefPerMin.hit();
        ClientInfo inf = this.getClientInfo(id);
        inf.dereference(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(VmId id) {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("touching client info of vm id " + id));
        }
        Map<VmId, ClientInfo> map = this._clientTable;
        synchronized (map) {
            ClientInfo info = this._clientTable.get(id);
            if (info != null) {
                info.touch();
            } else {
                Log.warning(this.getClass(), (Object)("NO CLIENT INFO FOUND FOR vm id " + id));
            }
        }
    }

    @Override
    public void exec(TaskContext ctx) {
        Log.debug(this.getClass(), (Object)"runner server GC...");
        this.removeTimedOutClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<VmId, ClientInfo> map = this._clientTable;
        synchronized (map) {
            this._clientTable.clear();
            Hub.serverRuntime.objectTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientInfo getClientInfo(VmId id) {
        Map<VmId, ClientInfo> map = this._clientTable;
        synchronized (map) {
            ClientInfo inf = this._clientTable.get(id);
            if (inf == null) {
                inf = new ClientInfo(id);
                this._clientTable.put(id, inf);
            }
            return inf;
        }
    }

    @Override
    public long getInterval() {
        return _gcInterval;
    }

    @Override
    public long getTimeout() {
        return _gcTimeout;
    }

    @Override
    public void setTimeout(long timeout) {
        _gcTimeout = timeout;
    }

    @Override
    public int getClientCount() {
        return this._clientTable.size();
    }

    @Override
    public MBeanContainer createMBean() throws Exception {
        ObjectName name = new ObjectName("sapia.ubik.rmi:type=ServerGC");
        return new MBeanContainer(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeTimedOutClients() {
        Map<VmId, ClientInfo> map = this._clientTable;
        synchronized (map) {
            ClientInfo[] infos = this._clientTable.values().toArray(new ClientInfo[this._clientTable.size()]);
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].isValid(_gcTimeout)) continue;
                if (Log.isInfo()) {
                    Log.info(this.getClass(), (Object)("removing timed-out client's references " + infos[i].vmid()));
                }
                infos[i].unregisterRefs();
                this._clientTable.remove(infos[i].vmid());
            }
        }
    }

    static class ClientInfo {
        private Map<OID, Count> _oids = new HashMap<OID, Count>();
        private long _lastAccess = System.currentTimeMillis();
        private VmId _id;

        ClientInfo(VmId id) {
            this._id = id;
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("Created a new client info for vmId " + this._id));
            }
        }

        VmId vmid() {
            return this._id;
        }

        void touch() {
            this._lastAccess = System.currentTimeMillis();
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("Touched this client info: " + this.toString()));
            }
        }

        boolean isValid(long timeout) {
            return System.currentTimeMillis() - this._lastAccess < timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reference(OID oid) {
            Map<OID, Count> map = this._oids;
            synchronized (map) {
                Count count = this._oids.get(oid);
                if (count == null) {
                    count = new Count();
                    this._oids.put(oid, count);
                }
                ++count.count;
                Hub.serverRuntime.objectTable.reference(oid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerRef(OID oid, Object obj) {
            Map<OID, Count> map = this._oids;
            synchronized (map) {
                Count c = new Count();
                ++c.count;
                this._oids.put(oid, c);
                Hub.serverRuntime.objectTable.register(oid, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dereference(OID oid) {
            Map<OID, Count> map = this._oids;
            synchronized (map) {
                Count count = this._oids.get(oid);
                if (count != null) {
                    Hub.serverRuntime.objectTable.dereference(oid, count.count);
                    this._oids.remove(oid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterRefs() {
            Map<OID, Count> map = this._oids;
            synchronized (map) {
                OID[] oids = this._oids.keySet().toArray(new OID[this._oids.size()]);
                for (int i = 0; i < oids.length; ++i) {
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)("Dereferencing: " + oids[i]));
                    }
                    Hub.serverRuntime.objectTable.dereference(oids[i], this._oids.get((Object)oids[i]).count);
                }
                this._oids.clear();
            }
        }

        int getSpecificCount(OID oid) {
            Count c = this._oids.get(oid);
            if (c == null) {
                return 0;
            }
            return c.count;
        }

        int getRefCount(OID oid) {
            return Hub.serverRuntime.objectTable.getRefCount(oid);
        }

        public String toString() {
            return super.toString() + "[vmId=" + this._id + " oidCount=" + this._oids.size() + " lastAccess=" + this._lastAccess;
        }
    }

    static class Count {
        int count = 0;

        Count() {
        }
    }
}

