/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.invocation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;

public class CallBackInvokeCommand
extends InvokeCommand
implements Externalizable {
    static final long serialVersionUID = 1L;
    private boolean _executed;
    private String _respId;
    private ServerAddress _callBackId;

    public CallBackInvokeCommand() {
    }

    public CallBackInvokeCommand(OID oid, String methodName, Object[] params, Class[] paramClasses, String transportType) {
        super(oid, methodName, params, paramClasses, transportType);
    }

    @Override
    public Object execute() throws Throwable {
        if (!this._executed) {
            this._executed = true;
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("dispatching callback command " + this._respId));
            }
            Hub.serverRuntime.processor.processAsyncCommand(this._respId, this._vmId, this._callBackId, this);
            return new Integer(0);
        }
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("executing callback command " + this._respId));
        }
        return super.execute();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._executed = in.readBoolean();
        this._respId = (String)in.readObject();
        this._callBackId = (ServerAddress)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this._executed);
        out.writeObject(this._respId);
        out.writeObject(this._callBackId);
    }

    final void setUp(String respId, ServerAddress callBackId) {
        this._respId = respId;
        this._callBackId = callBackId;
    }
}

