/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.invocation;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.command.ResponseLock;
import org.sapia.ubik.rmi.server.command.ResponseQueue;
import org.sapia.ubik.rmi.server.command.ResponseTimeOutException;
import org.sapia.ubik.rmi.server.invocation.CallBackInvokeCommand;
import org.sapia.ubik.rmi.server.invocation.ClientPostInvokeEvent;
import org.sapia.ubik.rmi.server.invocation.ClientPreInvokeEvent;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.invocation.ServerPostInvokeEvent;
import org.sapia.ubik.rmi.server.invocation.ServerPreInvokeEvent;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Topic;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.MarshalledObject;
import org.sapia.ubik.rmi.server.transport.RmiConnection;

public class InvocationDispatcher {
    static final long DEFAULT_CALLBACK_TIMEOUT = 30000L;
    private static long _timeout = 30000L;
    private Perf _perf = new Perf();
    private ResponseQueue _responses = ResponseQueue.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchInvocation(VmId vmId, Connections pool, InvokeCommand cmd) throws IOException, ClassNotFoundException, Throwable {
        Object toReturn;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("sending invocation for object: " + cmd.getOID() + " on vmId " + vmId));
        }
        ClientPreInvokeEvent pre = new ClientPreInvokeEvent(cmd);
        Hub.clientRuntime.dispatcher.dispatch(pre);
        if (VmId.getInstance().equals(vmId)) {
            Object target = Hub.serverRuntime.objectTable.getObjectFor(cmd.getOID());
            Method toCall = target.getClass().getMethod(pre.getCommand().getMethodName(), pre.getCommand().getParameterTypes());
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("performing colocated direct call ==> invoking " + toCall.getName() + " on " + cmd.getOID() + "(" + target + ")"));
            }
            ServerPreInvokeEvent serverPreEvent = new ServerPreInvokeEvent(pre.getCommand(), target);
            Hub.serverRuntime.dispatcher.dispatch(serverPreEvent);
            try {
                toReturn = toCall.invoke(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand().getParams());
                ServerPostInvokeEvent serverPostEvent = new ServerPostInvokeEvent(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand(), System.currentTimeMillis() - serverPreEvent.getInvokeTime());
                serverPostEvent.setResultObject(toReturn);
                Hub.serverRuntime.dispatchEvent(serverPostEvent);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                ServerPostInvokeEvent postEvt = new ServerPostInvokeEvent(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand(), System.currentTimeMillis() - serverPreEvent.getInvokeTime(), e);
                Hub.serverRuntime.dispatchEvent(postEvt);
                throw e;
            }
        }
        if (this._perf.acquireCon.isEnabled()) {
            this._perf.acquireCon.start();
        }
        RmiConnection conn = pool.acquire();
        if (this._perf.acquireCon.isEnabled()) {
            this._perf.acquireCon.end();
        }
        try {
            if (this._perf.invokeSend.isEnabled()) {
                this._perf.invokeSend.start();
            }
            conn.send(pre.getCommand(), vmId, conn.getServerAddress().getTransportType());
            if (this._perf.invokeSend.isEnabled()) {
                this._perf.invokeSend.end();
            }
            if (this._perf.invokeReceive.isEnabled()) {
                this._perf.invokeReceive.start();
            }
            toReturn = conn.receive();
            if (this._perf.invokeReceive.isEnabled()) {
                this._perf.invokeReceive.end();
            }
        }
        finally {
            pool.release(conn);
        }
        if (cmd.usesMarshalledObjects() && toReturn != null) {
            try {
                toReturn = ((MarshalledObject)toReturn).get(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassCastException e) {
                String aMessage = "Could not cast to MarshalledObject: " + toReturn.getClass() + "\n" + toReturn;
                Log.error(this.getClass(), (Object)aMessage);
                throw new ClassCastException(aMessage);
            }
        }
        ClientPostInvokeEvent post = new ClientPostInvokeEvent(pre.getCommand(), toReturn);
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"dispatching post-invocation event");
        }
        Hub.clientRuntime.dispatcher.dispatch(post);
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"returning invocation response");
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchInvocation(VmId vmId, Connections pool, CallBackInvokeCommand cmd) throws IOException, ClassNotFoundException, ResponseTimeOutException, Throwable {
        Object toReturn;
        ClientPreInvokeEvent pre = new ClientPreInvokeEvent(cmd);
        if (VmId.getInstance().equals(vmId)) {
            Object target = Hub.serverRuntime.objectTable.getObjectFor(cmd.getOID());
            Method toCall = target.getClass().getMethod(cmd.getMethodName(), cmd.getParameterTypes());
            if (Log.isInfo()) {
                Log.info(this.getClass(), (Object)("performing colocated callback call ==> invoking " + toCall.getName() + " on " + cmd.getOID() + "(" + target + ")"));
            }
            Hub.clientRuntime.dispatcher.dispatch(pre);
            ServerPreInvokeEvent serverPreEvent = new ServerPreInvokeEvent(pre.getCommand(), target);
            Hub.serverRuntime.dispatcher.dispatch(serverPreEvent);
            try {
                toReturn = toCall.invoke(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand().getParams());
                ServerPostInvokeEvent serverPostEvent = new ServerPostInvokeEvent(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand(), System.currentTimeMillis() - serverPreEvent.getInvokeTime());
                serverPostEvent.setResultObject(toReturn);
                Hub.serverRuntime.dispatchEvent(serverPostEvent);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                ServerPostInvokeEvent postEvt = new ServerPostInvokeEvent(serverPreEvent.getTarget(), serverPreEvent.getInvokeCommand(), System.currentTimeMillis() - serverPreEvent.getInvokeTime(), e);
                Hub.serverRuntime.dispatchEvent(postEvt);
                throw e;
            }
        }
        ResponseLock lock = this._responses.createResponseLock();
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("sending callback invocation " + lock.getId()));
        }
        cmd.setUp(lock.getId(), Hub.clientRuntime.getCallbackAddress(pool.getTransportType()));
        Hub.clientRuntime.dispatcher.dispatch(pre);
        RmiConnection conn = pool.acquire();
        try {
            conn.send(pre.getCommand(), vmId, conn.getServerAddress().getTransportType());
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"receiving ACK");
            }
            conn.receive();
        }
        finally {
            pool.release(conn);
        }
        try {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"waiting for response...");
            }
            toReturn = lock.waitResponse(_timeout);
        }
        catch (ResponseTimeOutException e) {
            throw e;
        }
        catch (InterruptedException e) {
            lock.release();
            throw new IOException("response queue thread interrupted");
        }
        if (cmd.usesMarshalledObjects() && toReturn != null) {
            try {
                toReturn = ((MarshalledObject)toReturn).get(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassCastException e) {
                String aMessage = "Could not cast to MarshalledObject: " + toReturn.getClass() + "\n" + toReturn;
                Log.error(this.getClass(), (Object)aMessage);
                throw new ClassCastException(aMessage);
            }
        }
        ClientPostInvokeEvent post = new ClientPostInvokeEvent(pre.getCommand(), toReturn);
        Hub.clientRuntime.dispatcher.dispatch(post);
        return toReturn;
    }

    private String className() {
        return this.getClass().getName();
    }

    static {
        if (System.getProperty("ubik.rmi.client.callback.timeout") != null) {
            try {
                _timeout = Long.parseLong("ubik.rmi.client.callback.timeout");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class Perf {
        Topic acquireCon;
        Topic invokeSend;
        Topic invokeReceive;

        Perf() {
            this.acquireCon = PerfAnalyzer.getInstance().getTopic(InvocationDispatcher.this.className() + ".AcquireConnection");
            this.invokeSend = PerfAnalyzer.getInstance().getTopic(InvocationDispatcher.this.className() + ".InvokeSend");
            this.invokeReceive = PerfAnalyzer.getInstance().getTopic(InvocationDispatcher.this.className() + ".InvokeReceive");
        }
    }
}

