/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.invocation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.OID;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.RmiUtils;
import org.sapia.ubik.rmi.server.ShutdownException;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.invocation.ServerPostInvokeEvent;
import org.sapia.ubik.rmi.server.invocation.ServerPreInvokeEvent;
import org.sapia.ubik.rmi.server.transport.ClassDescriptor;
import org.sapia.ubik.rmi.server.transport.MarshalledObject;

public class InvokeCommand
extends RMICommand
implements Externalizable {
    static final long serialVersionUID = 1L;
    private static final boolean _vmUsesMarshalledObjects = System.getProperty("ubik.rmi.marshalling") != null && System.getProperty("ubik.rmi.marshalling").equals("true");
    private transient Class[] _paramTypes;
    private transient String _transportType;
    private OID _oid;
    private String _methodName;
    private Object[] _params;
    private ClassDescriptor[] _paramClasses;
    private boolean _usesMarshalledObjects = _vmUsesMarshalledObjects;

    public InvokeCommand() {
    }

    public InvokeCommand(OID oid, String methodName, Object[] params, Class[] paramClasses, String transportType) {
        this._oid = oid;
        this._methodName = methodName;
        this._params = params;
        this._paramClasses = new ClassDescriptor[paramClasses.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            this._paramClasses[i] = new ClassDescriptor(paramClasses[i]);
        }
        this._paramTypes = paramClasses;
        this._transportType = transportType;
    }

    public OID getOID() {
        return this._oid;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Class[] getParameterTypes() {
        return this._paramTypes;
    }

    public void setParams(Object[] params) {
        this._params = params;
    }

    public boolean usesMarshalledObjects() {
        return this._usesMarshalledObjects;
    }

    public Object[] getParams() {
        return this._params;
    }

    @Override
    public Object execute() throws Throwable {
        if (Hub.isShutdown()) {
            throw new ShutdownException();
        }
        Object obj = Hub.serverRuntime.objectTable.getObjectFor(this._oid);
        if (this._paramTypes == null) {
            if (obj.getClass().getClassLoader() == null) {
                this.convertParams(Thread.currentThread().getContextClassLoader());
            } else {
                this.convertParams(obj.getClass().getClassLoader());
            }
        }
        Method mt = obj.getClass().getMethod(this._methodName, this._paramTypes);
        ServerPreInvokeEvent preEvt = new ServerPreInvokeEvent(this, obj);
        try {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("invoking " + mt.getName() + " on " + this._oid + "(" + obj + ")"));
            }
            Hub.serverRuntime.dispatchEvent(preEvt);
            Object toReturn = mt.invoke(preEvt.getTarget(), preEvt.getInvokeCommand().getParams());
            ServerPostInvokeEvent postEvt = new ServerPostInvokeEvent(preEvt.getTarget(), preEvt.getInvokeCommand(), System.currentTimeMillis() - preEvt.getInvokeTime());
            postEvt.setResultObject(toReturn);
            Hub.serverRuntime.dispatchEvent(postEvt);
            if (this._usesMarshalledObjects) {
                toReturn = new MarshalledObject(toReturn, VmId.getInstance(), this._config.getServerAddress().getTransportType(), this._oid.getCodebase());
            }
            return toReturn;
        }
        catch (Throwable e) {
            if (this._usesMarshalledObjects) {
                return new MarshalledObject(e, VmId.getInstance(), this._config.getServerAddress().getTransportType(), this._oid.getCodebase());
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            ServerPostInvokeEvent postEvt = new ServerPostInvokeEvent(preEvt.getTarget(), preEvt.getInvokeCommand(), System.currentTimeMillis() - preEvt.getInvokeTime(), e);
            Hub.serverRuntime.dispatchEvent(postEvt);
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._oid = (OID)in.readObject();
        this._methodName = (String)in.readObject();
        this._paramClasses = (ClassDescriptor[])in.readObject();
        this._params = (Object[])in.readObject();
        this._usesMarshalledObjects = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._oid);
        out.writeObject(this._methodName);
        if (this._usesMarshalledObjects && this._params != null && this._params.length > 0 && !(this._params[0] instanceof MarshalledObject)) {
            for (int i = 0; i < this._params.length; ++i) {
                this._params[i] = new MarshalledObject(this._params[i], this._vmId, this._transportType, RmiUtils.CODE_BASE);
            }
        }
        out.writeObject(this._paramClasses);
        out.writeObject(this._params);
        out.writeBoolean(this._usesMarshalledObjects);
    }

    protected void convertParams(ClassLoader loader) throws IOException, ClassNotFoundException {
        int i;
        this._paramTypes = new Class[this._paramClasses.length];
        for (i = 0; i < this._paramClasses.length; ++i) {
            this._paramTypes[i] = this._paramClasses[i].resolve(loader);
        }
        if (this._usesMarshalledObjects && this._params != null) {
            for (i = 0; i < this._params.length; ++i) {
                this._params[i] = ((MarshalledObject)this._params[i]).get(loader);
            }
        }
    }
}

