/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.invocation;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.command.CommandProcessor;
import org.sapia.ubik.rmi.server.command.Destination;
import org.sapia.ubik.rmi.server.command.ResponseQueue;
import org.sapia.ubik.rmi.server.command.ResponseSender;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.TransportManager;

public class RMICommandProcessor
extends CommandProcessor {
    private ResponseQueue _responses = ResponseQueue.getInstance();

    public RMICommandProcessor(int maxThreads) {
        super(maxThreads);
        super.setResponseSender(new RMIResponseSender());
    }

    @Override
    public void shutdown(long timeout) throws InterruptedException {
        super.shutdown(timeout);
        Log.warning(this.getClass(), (Object)"Shutting down incoming response queue");
        ResponseQueue.getInstance().shutdown(timeout);
        this._responses.shutdown(timeout);
    }

    public static final class ResponseListCommand
    extends RMICommand {
        private List _responses;

        public ResponseListCommand() {
        }

        ResponseListCommand(List responses) {
            this._responses = responses;
        }

        @Override
        public Object execute() throws Throwable {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"Receiving callbacks");
            }
            ResponseQueue.getInstance().onResponses(this._responses);
            return new Integer(0);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this._responses);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this._responses = (List)in.readObject();
        }
    }

    static final class RMIResponseSender
    implements ResponseSender {
        RMIResponseSender() {
        }

        @Override
        public void sendResponses(Destination dest, List responses) {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("Sending callback responses to " + dest));
            }
            if (responses.size() > 0) {
                RmiConnection conn = null;
                try {
                    conn = TransportManager.getConnectionsFor(dest.getServerAddress()).acquire();
                    conn.send(new ResponseListCommand(responses), dest.getVmId(), dest.getServerAddress().getTransportType());
                    conn.receive();
                }
                catch (Exception e) {
                    Log.error(RMICommandProcessor.class, (Object)e);
                    if (conn != null) {
                        conn.close();
                    }
                    return;
                }
                if (conn != null) {
                    try {
                        TransportManager.getConnectionsFor(dest.getServerAddress()).release(conn);
                    }
                    catch (Exception e) {
                        Log.error(RMICommandProcessor.class, (Object)e);
                    }
                }
            }
        }
    }
}

