/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.perf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.perf.Statistic;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;

public class CsvStatDumper
implements Task {
    private PrintStream _stream;
    private boolean _headerWritten;
    private SimpleDateFormat _dateFormat;

    public CsvStatDumper(File f) throws Exception {
        this._stream = new PrintStream(new FileOutputStream(f));
        this._dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SS");
    }

    @Override
    public void exec(TaskContext ctx) {
        List stats = Hub.statsCollector.getStats();
        if (!this._headerWritten) {
            this.writeHeaders(stats);
            this._headerWritten = true;
        }
        this.writeContent(stats);
    }

    private void writeContent(List stats) {
        this._stream.print(this.getDate());
        this._stream.print(",");
        for (int i = 0; i < stats.size(); ++i) {
            Statistic stat = (Statistic)stats.get(i);
            if (!stat.isEnabled()) continue;
            this._stream.print(stat.getStat());
            if (i >= stats.size() - 1) continue;
            this._stream.print(",");
        }
        this._stream.println();
        this._stream.flush();
    }

    private void writeHeaders(List stats) {
        this._stream.print("Time,");
        for (int i = 0; i < stats.size(); ++i) {
            Statistic stat = (Statistic)stats.get(i);
            if (!stat.isEnabled()) continue;
            this._stream.print(stat.getName());
            if (i >= stats.size() - 1) continue;
            this._stream.print(",");
        }
        this._stream.println();
        this._stream.flush();
    }

    private String getDate() {
        return this._dateFormat.format(new Date());
    }
}

