/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.perf;

import org.sapia.ubik.rmi.server.perf.Statistic;

public class HitsPerSecStatistic
extends Statistic {
    private long _sampleRate = 1000L;
    private long _startTime = System.currentTimeMillis();
    private int _hits;

    HitsPerSecStatistic(String name) {
        super(name);
    }

    HitsPerSecStatistic(String name, long sampleRate) {
        super(name);
        this._sampleRate = sampleRate;
    }

    public synchronized void hit() {
        ++this._hits;
    }

    public synchronized void hit(int increment) {
        this._hits += increment;
    }

    public long getStartTime() {
        return this._startTime;
    }

    @Override
    public synchronized double getStat() {
        if (System.currentTimeMillis() - this._startTime > this._sampleRate) {
            double timebase = this.convertMillis(System.currentTimeMillis() - this._startTime);
            double ratio = (double)this._hits / timebase;
            super.incrementDouble(ratio);
            this._hits = 0;
            this._startTime = System.currentTimeMillis();
        }
        return super.getStat();
    }

    @Override
    protected synchronized void onPostReset() {
        this._hits = 0;
        this._startTime = System.currentTimeMillis();
    }

    protected double convertMillis(long delay) {
        return (double)delay / 1000.0;
    }
}

