/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.perf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzerMBean;
import org.sapia.ubik.rmi.server.perf.Topic;

public class PerfAnalyzer
implements MBeanFactory {
    private static final PerfAnalyzer _perf = new PerfAnalyzer();
    private boolean _isEnabled;
    private Map _avgs = Collections.synchronizedMap(new HashMap());

    private PerfAnalyzer() {
        this._isEnabled = new PropUtil().addProperties(System.getProperties()).getBooleanProperty("ubik.rmi.stats.enabled", false);
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enable() {
        this._isEnabled = true;
        Map map = this._avgs;
        synchronized (map) {
            Topic[] topics = this._avgs.values().toArray(new Topic[this._avgs.size()]);
            for (int i = 0; i < topics.length; ++i) {
                topics[i].setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disable() {
        this._isEnabled = false;
        Map map = this._avgs;
        synchronized (map) {
            Topic[] topics = this._avgs.values().toArray(new Topic[this._avgs.size()]);
            for (int i = 0; i < topics.length; ++i) {
                topics[i].setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopic(String name) {
        Topic t = (Topic)this._avgs.get(name);
        if (t == null) {
            Map map = this._avgs;
            synchronized (map) {
                t = (Topic)this._avgs.get(name);
                if (t == null) {
                    t = new Topic(name);
                    this._avgs.put(name, t);
                    t.setEnabled(this._isEnabled);
                    return t;
                }
                return t;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTopics() {
        Map map = this._avgs;
        synchronized (map) {
            ArrayList topics = new ArrayList(this._avgs.size());
            topics.addAll(this._avgs.values());
            return topics;
        }
    }

    @Override
    public MBeanContainer createMBean() throws Exception {
        ObjectName name = new ObjectName("sapia.ubik.rmi:type=PerfAnalyzer");
        return new MBeanContainer(name, new PerfAnalyzerMBean());
    }

    public static PerfAnalyzer getInstance() {
        return _perf;
    }
}

