/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.perf;

import org.sapia.ubik.rmi.server.perf.StatValue;

public class Statistic {
    static final int DEFAULT_MAX_COUNT = 25;
    private String _name;
    private StatValue _value = new StatValue();
    private int _count;
    private int _maxCount;
    private boolean _enabled;

    public Statistic(String name) {
        this(name, 25);
    }

    public Statistic(String name, int maxCount) {
        this._name = name;
        this._maxCount = maxCount;
    }

    public Statistic setEnabled(boolean enabled) {
        this._enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public String getName() {
        return this._name;
    }

    public double getValue() {
        return this._value.get();
    }

    public void incrementLong(long inc) {
        if (this._enabled) {
            this.doIncrementLong(inc);
        }
    }

    public void incrementDouble(double inc) {
        if (this._enabled) {
            this.doIncrementDouble(inc);
        }
    }

    public void incrementInt(int inc) {
        if (this._enabled) {
            this.doIncrementInt(inc);
        }
    }

    public double getStat() {
        return this._value.avg(this._count);
    }

    public void reset() {
        this.doReset();
    }

    private synchronized void doReset() {
        if (this._count > this._maxCount) {
            this.onPreReset();
            this._value.set(this._value.avg(this._count));
            this._count = 0;
            this.onPostReset();
        }
    }

    public String toString() {
        return "[" + this._name + " = " + this._value + "]";
    }

    private synchronized void doIncrementLong(long inc) {
        ++this._count;
        this._value.incrementLong(inc);
        this.doReset();
    }

    private synchronized void doIncrementDouble(double inc) {
        ++this._count;
        this._value.incrementDouble(inc);
        this.doReset();
    }

    private synchronized void doIncrementInt(int inc) {
        ++this._count;
        this._value.incrementInt(inc);
        this.doReset();
    }

    protected void onPreReset() {
    }

    protected void onPostReset() {
    }
}

