/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.perf;

import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sapia.ubik.rmi.server.perf.Statistic;

public class StatsCollector {
    private static List _stats = Collections.synchronizedList(new ArrayList());
    private boolean _enabled = true;

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        List stats = this.getStats();
        for (int i = 0; i < stats.size(); ++i) {
            Statistic stat = (Statistic)stats.get(i);
            stat.setEnabled(enabled);
        }
    }

    public StatsCollector addStat(Statistic stat) {
        stat.setEnabled(this._enabled);
        _stats.add(new SoftReference<Statistic>(stat));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStats() {
        ArrayList<Statistic> toReturn = new ArrayList<Statistic>(_stats.size());
        List list = _stats;
        synchronized (list) {
            for (int i = 0; i < _stats.size(); ++i) {
                SoftReference ref = (SoftReference)_stats.get(i);
                Statistic stat = (Statistic)ref.get();
                if (stat == null) {
                    _stats.remove(i--);
                    continue;
                }
                toReturn.add(stat);
            }
        }
        return toReturn;
    }

    public void dumpStats(PrintStream ps) {
        ps.println("================= Ubik Stats Dump at " + new Date() + " =================");
        List stats = this.getStats();
        for (int i = 0; i < stats.size(); ++i) {
            Statistic stat = (Statistic)stats.get(i);
            if (!stat.isEnabled()) continue;
            this.dumpStat(ps, stat.getName(), stat.getStat());
        }
    }

    public void dumpStat(PrintStream ps, String name, Object value) {
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        ps.print(name);
        ps.print(":");
        this.printSpace(ps, name);
        ps.println(value);
    }

    public void dumpStat(PrintStream ps, String name, double value) {
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        ps.print(name);
        ps.print(":");
        this.printSpace(ps, name);
        ps.println(value);
    }

    private void printSpace(PrintStream ps, String name) {
        int space = 60 - name.length();
        for (int i = 0; i < space; ++i) {
            ps.print(' ');
        }
    }
}

