/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class ClassDescriptor
implements Externalizable {
    private static final long serialVersionUID = 6382603348796329430L;
    private static Map _primitives = new HashMap();
    private transient Class _type;
    private String _className;
    private boolean _primitive;

    public ClassDescriptor() {
    }

    public ClassDescriptor(Class type) {
        this._type = type;
        this._primitive = type.isPrimitive();
        this._className = type.getName();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._className = in.readUTF();
        this._primitive = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._className);
        out.writeBoolean(this._primitive);
    }

    public Class resolve(ClassLoader loader) throws ClassNotFoundException {
        if (this._primitive) {
            Class clazz = (Class)_primitives.get(this._className);
            if (clazz == null) {
                throw new ClassNotFoundException(this._className);
            }
            return clazz;
        }
        if (this._type == null) {
            this._type = loader.loadClass(this._className);
            return this._type;
        }
        return this._type;
    }

    static {
        _primitives.put(Boolean.TYPE.getName(), Boolean.TYPE);
        _primitives.put(Byte.TYPE.getName(), Byte.TYPE);
        _primitives.put(Character.TYPE.getName(), Character.TYPE);
        _primitives.put(Short.TYPE.getName(), Short.TYPE);
        _primitives.put(Integer.TYPE.getName(), Integer.TYPE);
        _primitives.put(Long.TYPE.getName(), Long.TYPE);
        _primitives.put(Float.TYPE.getName(), Float.TYPE);
        _primitives.put(Double.TYPE.getName(), Double.TYPE);
    }
}

