/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Topic;

public class MarshalOutputStream
extends ObjectOutputStream {
    private VmId _id;
    private String _transportType;
    private static Perf _perf = new Perf();

    public MarshalOutputStream(OutputStream os) throws IOException {
        super(os);
        super.enableReplaceObject(true);
    }

    public void setUp(VmId id, String transportType) {
        this._id = id;
        this._transportType = transportType;
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Remote) {
            if (this._id == null) {
                throw new IllegalStateException("VmId not set on " + this.getClass().getName());
            }
            if (MarshalOutputStream._perf.stubOutput.isEnabled()) {
                MarshalOutputStream._perf.stubOutput.start();
            }
            Object remote = Hub.asRemote(obj, this._id, this._transportType);
            if (MarshalOutputStream._perf.stubOutput.isEnabled()) {
                MarshalOutputStream._perf.stubOutput.end();
            }
            return remote;
        }
        return obj;
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        super.writeUnshared(obj);
    }

    private static String className() {
        return MarshalOutputStream.class.getName();
    }

    static /* synthetic */ String access$000() {
        return MarshalOutputStream.className();
    }

    static final class Perf {
        Topic stubOutput = PerfAnalyzer.getInstance().getTopic(MarshalOutputStream.access$000() + ".StubOutput");

        Perf() {
        }
    }
}

