/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.sapia.ubik.rmi.Utils;
import org.sapia.ubik.rmi.server.RmiUtils;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;

public class MarshalledObject
implements Externalizable {
    private byte[] _bytes;
    private String _codebase;

    public MarshalledObject() {
    }

    public MarshalledObject(Object o, VmId id, String transportType, String codebase) throws IOException {
        if (o != null) {
            this._bytes = MarshalledObject.serialize(id, transportType, o);
        }
        this._codebase = codebase;
    }

    public Object get(ClassLoader loader) throws IOException, ClassNotFoundException {
        if (this._bytes == null) {
            return this._bytes;
        }
        if (this._codebase != null && RmiUtils.CODE_DOWNLOAD) {
            return Utils.deserialize(this._bytes, loader, this._codebase);
        }
        return Utils.deserialize(this._bytes, loader);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._bytes = (byte[])in.readObject();
        this._codebase = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._bytes);
        out.writeObject(this._codebase);
    }

    private static byte[] serialize(VmId vmid, String transportType, Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MarshalOutputStream ous = new MarshalOutputStream(bos);
        ous.setUp(vmid, transportType);
        ous.writeObject(o);
        ous.flush();
        ous.close();
        return bos.toByteArray();
    }
}

