/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.TransportProvider;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioTcpTransportProvider;
import org.sapia.ubik.rmi.server.transport.socket.MultiplexSocketTransportProvider;
import org.sapia.ubik.rmi.server.transport.socket.SocketTransportProvider;

public class TransportManager {
    private static Map _providers = Collections.synchronizedMap(new HashMap());

    public static void registerProvider(TransportProvider provider) {
        if (_providers.containsKey(provider.getTransportType())) {
            throw new IllegalArgumentException("Transport provider already registered for: " + provider.getTransportType());
        }
        _providers.put(provider.getTransportType(), provider);
    }

    public static TransportProvider getProviderFor(String type) {
        TransportProvider provider = (TransportProvider)_providers.get(type);
        if (provider == null) {
            throw new IllegalArgumentException("No transport provider for: " + type);
        }
        return provider;
    }

    public static Connections getConnectionsFor(ServerAddress address) throws RemoteException {
        return TransportManager.getProviderFor(address.getTransportType()).getPoolFor(address);
    }

    public static SocketTransportProvider getDefaultProvider() {
        return (SocketTransportProvider)_providers.get("tcp/socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Map map = _providers;
        synchronized (map) {
            for (TransportProvider provider : _providers.values()) {
                provider.shutdown();
            }
        }
    }

    static {
        TransportProvider provider = new MultiplexSocketTransportProvider();
        TransportManager.registerProvider(provider);
        provider = new NioTcpTransportProvider();
        TransportManager.registerProvider(provider);
        String[] propNames = System.getProperties().keySet().toArray(new String[System.getProperties().size()]);
        for (int i = 0; i < propNames.length; ++i) {
            String propName = propNames[i];
            if (!propName.startsWith("ubik.rmi.transport.provider")) continue;
            String className = System.getProperty(propName);
            if (className == null) {
                throw new IllegalStateException("No class name defined for transport provider: " + propName);
            }
            try {
                provider = (TransportProvider)Class.forName(className).newInstance();
                TransportManager.registerProvider(provider);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not instantiate transport provider: " + className);
            }
        }
    }
}

