/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.rmi.RemoteException;
import org.apache.commons.httpclient.HttpClient;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.Pool;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import org.sapia.ubik.rmi.server.transport.http.HttpRmiClientConnection;

public class HttpClientConnectionPool
implements Connections {
    private HttpAddress _address;
    private HttpClient _client = new HttpClient();
    private InternalPool _pool = new InternalPool();

    public HttpClientConnectionPool(HttpAddress address) throws UriSyntaxException {
        this._address = address;
    }

    public HttpClientConnectionPool(Uri serverUri) {
        this._address = new HttpAddress(serverUri);
    }

    @Override
    public RmiConnection acquire() throws RemoteException {
        try {
            return ((HttpRmiClientConnection)this._pool.acquire()).setUp(this._client, this._address);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw new RemoteException("Could acquire connection", e);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public String getTransportType() {
        return this._address.getTransportType();
    }

    @Override
    public void release(Connection conn) {
        conn.close();
        this._pool.release(conn);
    }

    static class InternalPool
    extends Pool {
        InternalPool() {
        }

        @Override
        protected Object doNewObject() throws Exception {
            return new HttpRmiClientConnection();
        }
    }
}

