/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;

public class HttpRmiClientConnection
implements RmiConnection {
    private static final int DEFAULT_BUFSZ = 1024;
    private HttpAddress _address;
    private HttpClient _client;
    private PostMethod _post;
    private boolean _closed;
    private int _bufsz = 1024;

    @Override
    public void send(Object o, VmId associated, String transportType) throws IOException, RemoteException {
        this._post = new PostMethod(this._address.toString());
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this._bufsz);
        MarshalOutputStream mos = new MarshalOutputStream(bos);
        if (associated != null && transportType != null) {
            mos.setUp(associated, transportType);
        }
        mos.writeObject(o);
        mos.flush();
        mos.close();
        byte[] data = bos.toByteArray();
        if (data.length > this._bufsz) {
            this._bufsz = data.length;
        }
        this._post.setRequestContentLength(data.length);
        this._post.setRequestBody((InputStream)new ByteArrayInputStream(data));
        this._client.executeMethod((HttpMethod)this._post);
    }

    @Override
    public void close() {
        if (this._post != null && !this._closed) {
            this._post.releaseConnection();
            this._closed = true;
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        if (this._post == null) {
            throw new IllegalStateException("Cannot receive; data was not posted");
        }
        MarshalInputStream is = new MarshalInputStream(this._post.getResponseBodyAsStream());
        try {
            Object object = is.readObject();
            return object;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage() + "\nHTTP RESPONSE:\n" + this._post == null ? "null" : this._post.getResponseBodyAsString());
            throw ioe;
        }
        finally {
            is.close();
        }
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        this.send(o, null, null);
    }

    HttpRmiClientConnection setUp(HttpClient client, HttpAddress addr) {
        this._closed = false;
        this._client = client;
        this._address = addr;
        return this;
    }
}

