/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.http.HeaderHandler;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import org.sapia.ubik.rmi.server.transport.http.HttpConsts;
import org.sapia.ubik.rmi.server.transport.http.ServiceMapper;
import org.sapia.ubik.rmi.server.transport.http.UbikHttpHandler;
import simple.http.ProtocolHandler;
import simple.http.connect.Connection;
import simple.http.connect.ConnectionFactory;

class HttpRmiServer
implements Server,
HttpConsts {
    private String _transportType;
    private String _path;
    private Uri _serverUrl;
    private ServiceMapper _services;
    private ServerSocket _server;
    private HttpAddress _address;
    private int _maxThreads = 0;
    private int _localPort;

    HttpRmiServer(ServiceMapper services, String transportType, Uri serverUrl, String path, int localPort) {
        if (serverUrl.getPort() <= 0) {
            throw new IllegalStateException("Server does not support dynamic port");
        }
        this._transportType = transportType;
        this._serverUrl = serverUrl;
        this._path = path;
        this._services = services;
        this._localPort = localPort;
    }

    @Override
    public void close() {
        if (this._server != null) {
            try {
                this._server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    void setMaxThreads(int max) {
        this._maxThreads = max;
    }

    @Override
    public void start() throws RemoteException {
        try {
            this._address = new HttpAddress(this._serverUrl);
            UbikHttpHandler svc = new UbikHttpHandler(this._serverUrl, this._maxThreads);
            this._services.addService(this._path, svc);
            HeaderHandler hh = new HeaderHandler(this._services);
            Connection conn = ConnectionFactory.getConnection((ProtocolHandler)this._services);
            this._server = new ServerSocket(this._localPort);
            conn.connect(this._server);
        }
        catch (UnknownHostException e) {
            throw new RemoteException("Could not acquire local address", e);
        }
        catch (IOException e) {
            throw new RemoteException("Could not instantiate server socket", e);
        }
        catch (Exception e) {
            throw new RemoteException("Could not instantiate server socket", e);
        }
    }
}

