/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.rmi.RemoteException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import simple.http.Request;
import simple.http.Response;

class HttpRmiServerConnection
implements RmiConnection {
    static final int DEFAULT_BUFSZ = 1024;
    private int _bufsz = 1024;
    private Request _req;
    private Response _res;
    private HttpAddress _address;

    HttpRmiServerConnection(HttpAddress address, Request req, Response res) {
        this._req = req;
        this._res = res;
        this._address = address;
    }

    @Override
    public void send(Object o, VmId associated, String transportType) throws IOException, RemoteException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this._bufsz);
            MarshalOutputStream mos = new MarshalOutputStream(bos);
            if (associated != null && transportType != null) {
                mos.setUp(associated, transportType);
            }
            mos.writeObject(o);
            mos.flush();
            mos.close();
            byte[] data = bos.toByteArray();
            if (data.length > this._bufsz) {
                this._bufsz = data.length;
            }
            this._res.setContentLength(data.length);
            OutputStream os = this._res.getOutputStream(data.length);
            os.write(data);
            os.flush();
            os.close();
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
        catch (Exception e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
    }

    @Override
    public void close() {
        try {
            this._res.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        try {
            MarshalInputStream is = new MarshalInputStream(this._req.getInputStream());
            return is.readObject();
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        try {
            MarshalOutputStream os = new MarshalOutputStream(this._res.getOutputStream());
            os.writeObject(o);
            os.flush();
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

