/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.net.SocketException;
import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.rmi.server.Config;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.transport.RmiConnection;

class HttpRmiServerThread
extends PooledThread {
    private PerfAnalyzer _perf = PerfAnalyzer.getInstance();

    HttpRmiServerThread() {
    }

    @Override
    protected void doExec(Object task) {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"handling request");
        }
        Request req = (Request)task;
        RmiConnection conn = (RmiConnection)req.getConnection();
        Object resp = null;
        try {
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)"receiving command");
            }
            RMICommand cmd = (RMICommand)req.getConnection().receive();
            if (Log.isDebug()) {
                Log.debug(this.getClass(), (Object)("command received: " + cmd.getClass().getName() + " from " + req.getConnection().getServerAddress() + '@' + cmd.getVmId()));
            }
            cmd.init(new Config(req.getServerAddress(), req.getConnection()));
            try {
                if (this._perf.isEnabled() && cmd instanceof InvokeCommand) {
                    this._perf.getTopic(this.getClass().getName() + ".RemoteCall").start();
                }
                resp = cmd.execute();
                if (this._perf.isEnabled() && cmd instanceof InvokeCommand) {
                    this._perf.getTopic(this.getClass().getName() + ".RemoteCall").end();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                t.fillInStackTrace();
                resp = t;
            }
            if (this._perf.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.getTopic(this.getClass().getName() + ".SendResponse").start();
            }
            conn.send(resp, cmd.getVmId(), cmd.getServerAddress().getTransportType());
            if (this._perf.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.getTopic(this.getClass().getName() + ".SendResponse").end();
            }
        }
        catch (RuntimeException e) {
            Log.error(this.getClass(), (Object)"RuntimeException caught sending response", (Throwable)e);
            try {
                e.fillInStackTrace();
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            e.fillInStackTrace();
            Log.error(this.getClass(), (Object)"Class not found while receiving request", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                e2.fillInStackTrace();
                req.getConnection().close();
                return;
            }
        }
        catch (EOFException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (SocketException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (NotSerializableException e) {
            e.fillInStackTrace();
            Log.error(this.getClass().getName(), (Object)"Could not serialize class while sending response", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (InvalidClassException e) {
            e.fillInStackTrace();
            Log.error(this.getClass(), (Object)"Class is invalid; object could not be sent", (Throwable)e);
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
    }

    @Override
    protected void handleExecutionException(Exception e) {
        Log.warning(this.getClass(), (Object)"Error executing thread", (Throwable)e);
    }
}

