/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.TransportProvider;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import org.sapia.ubik.rmi.server.transport.http.HttpClientConnectionPool;
import org.sapia.ubik.rmi.server.transport.http.HttpConsts;
import org.sapia.ubik.rmi.server.transport.http.HttpRmiServer;
import org.sapia.ubik.rmi.server.transport.http.JdkClientConnectionPool;
import org.sapia.ubik.rmi.server.transport.http.ServiceMapper;

public class HttpTransportProvider
implements TransportProvider,
HttpConsts {
    private static boolean _usesJakarta;
    private String _transportType;
    private ServiceMapper _services = new ServiceMapper();
    private Map _pools = Collections.synchronizedMap(new HashMap());

    public HttpTransportProvider() {
        this("http", new File(System.getProperty("user.dir")));
    }

    public HttpTransportProvider(String transportType) {
        this(transportType, new File(System.getProperty("user.dir")));
    }

    public HttpTransportProvider(String transportType, File baseDir) {
        this._transportType = transportType;
    }

    public ServiceMapper getServices() {
        return this._services;
    }

    @Override
    public synchronized Connections getPoolFor(ServerAddress address) throws RemoteException {
        Connections conns = (Connections)this._pools.get(address);
        if (conns == null) {
            try {
                conns = _usesJakarta ? new HttpClientConnectionPool((HttpAddress)address) : new JdkClientConnectionPool((HttpAddress)address);
                this._pools.put(address, conns);
            }
            catch (UriSyntaxException e) {
                throw new RemoteException("Could not process given address", e);
            }
        }
        return conns;
    }

    @Override
    public String getTransportType() {
        return this._transportType;
    }

    @Override
    public Server newDefaultServer() throws RemoteException {
        throw new UnsupportedOperationException("Transport provider does not support anonymous servers/dynamic ports");
    }

    @Override
    public Server newServer(Properties props) throws RemoteException {
        String contextPath;
        Uri serverUrl;
        String portStr = props.getProperty("ubik.rmi.transport.http.port");
        int port = 8080;
        if (portStr == null) {
            Log.warning(this.getClass(), (Object)("Property 'ubik.rmi.transport.http.port' not specified; using default: " + port));
        } else {
            port = Integer.parseInt(portStr);
        }
        if (props.getProperty("ubik.rmi.transport.http.url") != null) {
            try {
                serverUrl = Uri.parse(props.getProperty("ubik.rmi.transport.http.url"));
                if (serverUrl.getPort() == -1) {
                    serverUrl.setPort(8080);
                }
                contextPath = serverUrl.getPath();
            }
            catch (UriSyntaxException e) {
                throw new RemoteException("Could not parse server URL", e);
            }
        }
        contextPath = props.getProperty("ubik.rmi.transport.http.path", "/ubik");
        try {
            serverUrl = Uri.parse("http://" + InetAddress.getLocalHost().getHostAddress() + ":" + port + "/" + contextPath);
        }
        catch (UriSyntaxException e) {
            throw new RemoteException("Could not parse server URL", e);
        }
        catch (UnknownHostException e) {
            throw new RemoteException("Could not acquire local address", e);
        }
        String maxThreads = props.getProperty("ubik.rmi.server.max-threads");
        int max = 0;
        if (maxThreads != null) {
            try {
                max = Integer.parseInt(maxThreads);
            }
            catch (NumberFormatException e) {
                throw new RemoteException("Invalid value for 'ubik.rmi.server.max-threads' : " + maxThreads);
            }
            if (max < 0) {
                max = 0;
            }
        }
        HttpRmiServer svr = new HttpRmiServer(this._services, this._transportType, serverUrl, contextPath, port);
        svr.setMaxThreads(max);
        return svr;
    }

    @Override
    public void shutdown() {
    }

    public ServiceMapper getServiceMapper() {
        return this._services;
    }

    static {
        try {
            Class.forName("org.apache.commons.httpclient.HttpClient");
            _usesJakarta = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

