/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.rmi.RemoteException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.Pool;
import org.sapia.ubik.net.Uri;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import org.sapia.ubik.rmi.server.transport.http.JdkRmiClientConnection;

public class JdkClientConnectionPool
implements Connections {
    private HttpAddress _address;
    private InternalPool _pool = new InternalPool();

    public JdkClientConnectionPool(HttpAddress address) throws UriSyntaxException {
        this._address = address;
    }

    public JdkClientConnectionPool(String transportType, Uri serverUri) {
        this._address = new HttpAddress(serverUri);
    }

    @Override
    public RmiConnection acquire() throws RemoteException {
        try {
            return ((JdkRmiClientConnection)this._pool.acquire()).setUp(this._address);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw new RemoteException("Could acquire connection", e);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public String getTransportType() {
        return this._address.getTransportType();
    }

    @Override
    public void release(Connection conn) {
        conn.close();
        this._pool.release(conn);
    }

    static class InternalPool
    extends Pool {
        InternalPool() {
        }

        @Override
        protected Object doNewObject() throws Exception {
            return new JdkRmiClientConnection();
        }
    }
}

