/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;

public class JdkRmiClientConnection
implements RmiConnection {
    private static final int DEFAULT_BUFSZ = 1024;
    private static final String POST_METHOD = "POST";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private HttpAddress _address;
    private URL _url;
    private boolean _closed;
    private HttpURLConnection _conn;
    private int _bufsz = 1024;

    @Override
    public void send(Object o, VmId associated, String transportType) throws IOException, RemoteException {
        this._conn = (HttpURLConnection)this._url.openConnection();
        this._conn.setDoInput(true);
        this._conn.setDoOutput(true);
        this._conn.setUseCaches(false);
        this._conn.setRequestMethod(POST_METHOD);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this._bufsz);
        MarshalOutputStream mos = new MarshalOutputStream(bos);
        if (associated != null && transportType != null) {
            mos.setUp(associated, transportType);
        }
        mos.writeObject(o);
        mos.flush();
        mos.close();
        byte[] data = bos.toByteArray();
        if (data.length > this._bufsz) {
            this._bufsz = data.length;
        }
        this._conn.setRequestProperty(CONTENT_LENGTH_HEADER, "" + data.length);
        OutputStream os = this._conn.getOutputStream();
        os.write(data);
        os.flush();
        os.close();
    }

    @Override
    public void close() {
        if (this._conn != null && !this._closed) {
            this._conn.disconnect();
            this._closed = true;
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        if (this._conn == null) {
            throw new IllegalStateException("Cannot receive; data was not posted");
        }
        MarshalInputStream is = new MarshalInputStream(this._conn.getInputStream());
        try {
            Object object = is.readObject();
            return object;
        }
        finally {
            is.close();
        }
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        this.send(o, null, null);
    }

    JdkRmiClientConnection setUp(HttpAddress addr) throws RemoteException {
        this._closed = false;
        if (this._url == null) {
            try {
                this._url = new URL(addr.toString());
            }
            catch (MalformedURLException e) {
                throw new RemoteException(addr.toString(), e);
            }
        }
        this._address = addr;
        return this;
    }
}

