/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http;

import java.util.HashMap;
import java.util.Map;
import simple.http.ProtocolHandler;
import simple.http.Request;
import simple.http.Response;
import simple.http.load.Service;
import simple.util.parse.URIParser;

public class ServiceMapper
implements ProtocolHandler {
    private Map<String, ProtocolHandler> _services = new HashMap<String, ProtocolHandler>();

    public void addService(String contextPath, ProtocolHandler svc) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        this._services.put(contextPath, svc);
    }

    public void addService(String contextPath, Service svc) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        this._services.put(contextPath, new ProtocolHandlerAdapter(svc));
    }

    public void handle(Request req, Response res) {
        ProtocolHandler svc;
        URIParser uri = new URIParser();
        uri.parse(req.getURI());
        if (uri.getPath() != null && (svc = this._services.get(uri.getPath().getPath())) != null) {
            svc.handle(req, res);
        }
    }

    static class ProtocolHandlerAdapter
    implements ProtocolHandler {
        private Service service;

        public ProtocolHandlerAdapter(Service service) {
            this.service = service;
        }

        public void handle(Request req, Response res) {
            this.service.handle(req, res);
        }
    }
}

