/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.rmi.RemoteException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletAddress;

public class ServletRmiConnection
implements RmiConnection {
    static final int DEFAULT_BUFSZ = 1024;
    private int _bufsz = 1024;
    private HttpServletRequest _req;
    private HttpServletResponse _res;
    private ServletAddress _address;

    ServletRmiConnection(ServletAddress address, HttpServletRequest req, HttpServletResponse res) {
        this._req = req;
        this._res = res;
        this._address = address;
    }

    @Override
    public void send(Object o, VmId associated, String transportType) throws IOException, RemoteException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this._bufsz);
            MarshalOutputStream mos = new MarshalOutputStream(bos);
            if (associated != null && transportType != null) {
                mos.setUp(associated, transportType);
            }
            mos.writeObject(o);
            mos.flush();
            mos.close();
            byte[] data = bos.toByteArray();
            if (data.length > this._bufsz) {
                this._bufsz = data.length;
            }
            this._res.setContentLength(data.length);
            ServletOutputStream os = this._res.getOutputStream();
            os.write(data);
            os.flush();
            os.close();
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
    }

    @Override
    public void close() {
        try {
            this._res.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        MarshalInputStream is = new MarshalInputStream((InputStream)this._req.getInputStream());
        return is.readObject();
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        try {
            MarshalOutputStream os = new MarshalOutputStream((OutputStream)this._res.getOutputStream());
            os.writeObject(o);
            os.flush();
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
    }
}

