/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.http.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.UriSyntaxException;
import org.sapia.ubik.rmi.server.Config;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Topic;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.TransportProvider;
import org.sapia.ubik.rmi.server.transport.http.HttpAddress;
import org.sapia.ubik.rmi.server.transport.http.HttpClientConnectionPool;
import org.sapia.ubik.rmi.server.transport.http.JdkClientConnectionPool;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletAddress;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletConsts;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletRmiConnection;
import org.sapia.ubik.rmi.server.transport.http.servlet.ServletServer;

public class ServletTransportProvider
implements TransportProvider,
ServletConsts {
    private static boolean _usesJakarta;
    private Perf _perf = new Perf();
    private ServletAddress _addr;
    private String _transportType;
    private Map _pools = Collections.synchronizedMap(new HashMap());

    public ServletTransportProvider() {
        this("http/servlet");
    }

    protected ServletTransportProvider(String transportType) {
        this._transportType = transportType;
    }

    @Override
    public String getTransportType() {
        return this._transportType;
    }

    @Override
    public Server newDefaultServer() throws RemoteException {
        throw new UnsupportedOperationException("Transport provider does not support anonymous servers/dynamic ports");
    }

    @Override
    public Server newServer(Properties props) throws RemoteException {
        String servletUrl = props.getProperty("ubik.rmi.transport.servlet.url");
        if (servletUrl == null) {
            throw new RemoteException("'ubik.rmi.transport.servlet.url' not specified");
        }
        try {
            this._addr = new ServletAddress(servletUrl);
            return new ServletServer(this._addr);
        }
        catch (UriSyntaxException e) {
            throw new RemoteException("Could not parse servlet URL property", e);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public synchronized Connections getPoolFor(ServerAddress address) throws RemoteException {
        Connections conns = (Connections)this._pools.get(address);
        if (conns == null) {
            try {
                conns = _usesJakarta ? new HttpClientConnectionPool((HttpAddress)address) : new JdkClientConnectionPool((HttpAddress)address);
                this._pools.put(address, conns);
            }
            catch (UriSyntaxException e) {
                throw new RemoteException("Could not process given address", e);
            }
        }
        return conns;
    }

    public void handleRequest(HttpServletRequest httpReq, HttpServletResponse httpRes) {
        ServletRmiConnection conn = new ServletRmiConnection(this._addr, httpReq, httpRes);
        Request req = new Request(conn, this._addr);
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"handling request");
        }
        Object resp = null;
        try {
            RMICommand cmd;
            block27: {
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)"receiving command");
                }
                cmd = (RMICommand)req.getConnection().receive();
                if (Log.isDebug()) {
                    Log.debug(this.getClass(), (Object)("command received: " + cmd.getClass().getName() + " from " + req.getConnection().getServerAddress() + '@' + cmd.getVmId()));
                }
                cmd.init(new Config(req.getServerAddress(), req.getConnection()));
                try {
                    if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                        this._perf.remoteCall.start();
                    }
                    resp = cmd.execute();
                    if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                        this._perf.remoteCall.end();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    t.fillInStackTrace();
                    resp = t;
                    if (!this._perf.remoteCall.isEnabled() || !(cmd instanceof InvokeCommand)) break block27;
                    this._perf.remoteCall.end();
                }
            }
            if (this._perf.sendResponse.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.sendResponse.start();
            }
            conn.send(resp, cmd.getVmId(), cmd.getServerAddress().getTransportType());
            if (this._perf.sendResponse.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.sendResponse.end();
            }
        }
        catch (RuntimeException e) {
            Log.error(this.getClass(), (Object)"RuntimeException caught sending response", (Throwable)e);
            try {
                e.fillInStackTrace();
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            e.fillInStackTrace();
            Log.error(this.getClass(), (Object)"Class not found while receiving sending request", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                e2.fillInStackTrace();
                req.getConnection().close();
                return;
            }
        }
        catch (EOFException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (SocketException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (NotSerializableException e) {
            e.fillInStackTrace();
            Log.error(this.getClass().getName(), (Object)"Could not serialize class while sending response", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (InvalidClassException e) {
            e.fillInStackTrace();
            Log.error(this.getClass(), (Object)"Class is invalid; object could not be sent", (Throwable)e);
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
    }

    private String className() {
        return this.getClass().getName();
    }

    static {
        try {
            Class.forName("org.apache.commons.httpclient.HttpClient");
            _usesJakarta = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Perf {
        Topic remoteCall;
        Topic sendResponse;

        Perf() {
            this.remoteCall = PerfAnalyzer.getInstance().getTopic(ServletTransportProvider.this.className() + ".RemoteCall");
            this.sendResponse = PerfAnalyzer.getInstance().getTopic(ServletTransportProvider.this.className() + ".SendResponse");
        }
    }
}

