/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.net.SocketException;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.Config;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Topic;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioTcpRmiServerConnection;

public class NioHandler
extends IoHandlerAdapter {
    private Perf _perf = new Perf();
    private ServerAddress _addr;

    public NioHandler(ServerAddress addr) {
        this._addr = addr;
    }

    public void sessionCreated(IoSession sess) throws Exception {
    }

    public void exceptionCaught(IoSession sess, Throwable err) throws Exception {
        Log.error(((Object)((Object)this)).getClass(), (Object)err);
        sess.close();
    }

    public void messageReceived(IoSession sess, Object msg) throws Exception {
        NioTcpRmiServerConnection conn = new NioTcpRmiServerConnection(this._addr, sess, msg);
        Request req = new Request(conn, this._addr);
        if (Log.isDebug()) {
            Log.debug(((Object)((Object)this)).getClass(), (Object)"handling request");
        }
        Object resp = null;
        try {
            RMICommand cmd;
            block27: {
                if (Log.isDebug()) {
                    Log.debug(((Object)((Object)this)).getClass(), (Object)"receiving command");
                }
                cmd = (RMICommand)req.getConnection().receive();
                if (Log.isDebug()) {
                    Log.debug(((Object)((Object)this)).getClass(), (Object)("command received: " + cmd.getClass().getName() + " from " + req.getConnection().getServerAddress() + '@' + cmd.getVmId()));
                }
                cmd.init(new Config(req.getServerAddress(), req.getConnection()));
                try {
                    if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                        this._perf.remoteCall.start();
                    }
                    resp = cmd.execute();
                    if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                        this._perf.remoteCall.end();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    t.fillInStackTrace();
                    resp = t;
                    if (!this._perf.remoteCall.isEnabled() || !(cmd instanceof InvokeCommand)) break block27;
                    this._perf.remoteCall.end();
                }
            }
            if (this._perf.sendResponse.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.sendResponse.start();
            }
            conn.send(resp, cmd.getVmId(), cmd.getServerAddress().getTransportType());
            if (this._perf.sendResponse.isEnabled() && cmd instanceof InvokeCommand) {
                this._perf.sendResponse.end();
            }
        }
        catch (RuntimeException e) {
            Log.error(((Object)((Object)this)).getClass(), (Object)"RuntimeException caught sending response", (Throwable)e);
            try {
                e.fillInStackTrace();
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            e.fillInStackTrace();
            Log.error(((Object)((Object)this)).getClass(), (Object)"Class not found while receiving sending request", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                e2.fillInStackTrace();
                req.getConnection().close();
                return;
            }
        }
        catch (EOFException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (SocketException e) {
            e.fillInStackTrace();
            req.getConnection().close();
            return;
        }
        catch (NotSerializableException e) {
            e.fillInStackTrace();
            Log.error(((Object)((Object)this)).getClass().getName(), (Object)"Could not serialize class while sending response", (Throwable)e);
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (InvalidClassException e) {
            Log.error(((Object)((Object)this)).getClass(), (Object)"Class is invalid; object could not be sent", (Throwable)e);
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
            try {
                req.getConnection().send(e);
            }
            catch (IOException e2) {
                req.getConnection().close();
                return;
            }
        }
    }

    private String className() {
        return ((Object)((Object)this)).getClass().getName();
    }

    class Perf {
        Topic remoteCall;
        Topic sendResponse;

        Perf() {
            this.remoteCall = PerfAnalyzer.getInstance().getTopic(NioHandler.this.className() + ".RemoteCall");
            this.sendResponse = PerfAnalyzer.getInstance().getTopic(NioHandler.this.className() + ".SendResponse");
        }
    }
}

