/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.util.ByteVector;
import org.sapia.ubik.util.ByteVectorInputStream;

public class NioRequestDecoder
extends CumulativeProtocolDecoder {
    private static final String DECODER_STATE = "DECODER_STATE";

    protected boolean doDecode(IoSession sess, ByteBuffer buf, ProtocolDecoderOutput output) throws Exception {
        if (buf.prefixedDataAvailable(4)) {
            int length = buf.getInt();
            byte[] bytes = new byte[length];
            buf.get(bytes);
            DecoderState ds = (DecoderState)sess.getAttribute(DECODER_STATE);
            if (ds == null) {
                ds = new DecoderState();
                sess.setAttribute(DECODER_STATE, (Object)ds);
                ds.vector.clear(false);
                ds.vector.write(bytes);
                ds.vector.reset();
                ds.mis = new MarshalInputStream(new ByteVectorInputStream(ds.vector));
            } else {
                ds.vector.clear(false);
                ds.vector.write(bytes);
                ds.vector.reset();
            }
            output.write(ds.mis.readObject());
            return true;
        }
        return false;
    }

    static class DecoderState {
        ByteVector vector = new ByteVector(4000, 2000);
        MarshalInputStream mis;

        DecoderState() {
        }
    }
}

