/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.ByteArrayOutputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioResponse;

public class NioResponseEncoder
implements ProtocolEncoder {
    private static final String ENCODER_STATE = "ENCODER_STATE";

    public void encode(IoSession sess, Object toEncode, ProtocolEncoderOutput output) throws Exception {
        EncoderState es = (EncoderState)sess.getAttribute(ENCODER_STATE);
        if (es == null) {
            es = new EncoderState();
            es.mos = new MarshalOutputStream(es.bos);
            sess.setAttribute(ENCODER_STATE, (Object)es);
        } else {
            es.bos.reset();
        }
        NioResponse resp = (NioResponse)toEncode;
        es.mos.setUp(resp.getAssociatedVmId(), resp.getTransportType());
        es.mos.writeObject(resp.getObject());
        es.mos.flush();
        byte[] toSend = es.bos.toByteArray();
        ByteBuffer buffer = ByteBuffer.allocate((int)toSend.length, (boolean)false);
        buffer.put(toSend);
        buffer.flip();
        output.write(buffer);
    }

    public void dispose(IoSession arg0) throws Exception {
    }

    static class EncoderState {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4000);
        MarshalOutputStream mos;

        EncoderState() {
        }
    }
}

