/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.rmi.RemoteException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TcpPortSelector;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioAddress;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioCodecFactory;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioHandler;

class NioServer
implements Server {
    private SocketAcceptor _acceptor = new SocketAcceptor();
    private InetSocketAddress _inetAddr;
    private NioAddress _addr;
    private NioHandler _handler;
    private ExecutorService _executor;

    NioServer(InetSocketAddress inetAddr, int bufsize, int maxThreads) throws IOException {
        if (maxThreads <= 0) {
            Log.debug(this.getClass(), (Object)"Using a cached thread pool (no max threads)");
            this._executor = Executors.newCachedThreadPool();
        } else {
            Log.debug(this.getClass(), (Object)("Using maximum number of threads: " + maxThreads));
            this._executor = Executors.newFixedThreadPool(maxThreads);
        }
        this._acceptor.getFilterChain().addLast("protocol", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new NioCodecFactory()));
        this._acceptor.getFilterChain().addLast("threads", (IoFilter)new ExecutorFilter((Executor)this._executor));
        if (inetAddr.getPort() != 0) {
            this._inetAddr = inetAddr;
        } else {
            int randomPort = new TcpPortSelector().select(inetAddr.getAddress().getHostAddress());
            this._inetAddr = new InetSocketAddress(inetAddr.getAddress().getHostAddress(), randomPort);
        }
        this._addr = new NioAddress(this._inetAddr.getAddress().getHostAddress(), this._inetAddr.getPort());
        this._handler = new NioHandler(this._addr);
    }

    public ServerAddress getAddress() {
        return this.getServerAddress();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._addr;
    }

    @Override
    public void start() throws RemoteException {
        try {
            this._acceptor.bind((SocketAddress)this._inetAddr, (IoHandler)this._handler);
        }
        catch (IOException e) {
            throw new RemoteException("Could not start acceptor", e);
        }
    }

    @Override
    public void close() {
        this._acceptor.unbind((SocketAddress)this._inetAddr);
    }
}

