/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Hashtable;
import java.util.Map;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ConnectionPool;
import org.sapia.ubik.net.DefaultClientSocketFactory;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioAddress;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioRmiConnectionFactory;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;

public class NioTcpClientConnectionPool
implements Connections {
    private static Map _pools = new Hashtable();
    private static boolean _started;
    ConnectionPool _pool;

    NioTcpClientConnectionPool(String host, int port, int bufsize) {
        this._pool = new ConnectionPool(host, port, new NioRmiConnectionFactory(bufsize), (RMIClientSocketFactory)new DefaultClientSocketFactory());
    }

    @Override
    public RmiConnection acquire() throws RemoteException {
        try {
            return (RmiConnection)this._pool.acquire();
        }
        catch (IOException e) {
            throw new RemoteException("Could not acquire a connection", e);
        }
    }

    @Override
    public void release(Connection conn) {
        this._pool.release(conn);
    }

    @Override
    public void clear() {
        this._pool.shrinkTo(0);
    }

    @Override
    public String getTransportType() {
        return "tcp/nio";
    }

    ConnectionPool internalPool() {
        return this._pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void shutdown() {
        if (_started) {
            Map map = _pools;
            synchronized (map) {
                for (NioTcpClientConnectionPool pool : _pools.values()) {
                    pool.internalPool().shrinkTo(0);
                }
            }
        }
    }

    static synchronized NioTcpClientConnectionPool getInstance(ServerAddress address, int bufsize) {
        NioTcpClientConnectionPool pool;
        if (!_started) {
            _started = true;
            Hub.taskMan.addTask(new TaskContext(NioTcpClientConnectionPool.class.getName(), 5000L), new PoolCleaner(_pools));
        }
        if ((pool = (NioTcpClientConnectionPool)_pools.get(address)) == null) {
            pool = new NioTcpClientConnectionPool(((NioAddress)address).getHost(), ((NioAddress)address).getPort(), bufsize);
            _pools.put(address, pool);
        }
        return pool;
    }

    static synchronized void invalidate(TCPAddress id) {
        _pools.remove(id);
    }

    static final class PoolCleaner
    implements Task {
        static final long INTERVAL = 5000L;
        Map _pools;

        PoolCleaner(Map pools) {
            this._pools = pools;
        }

        @Override
        public void exec(TaskContext context) {
            NioTcpClientConnectionPool[] pools = this._pools.values().toArray(new NioTcpClientConnectionPool[this._pools.size()]);
            for (int i = 0; i < pools.length; ++i) {
                if (System.currentTimeMillis() - pools[i].internalPool().getLastUsageTime() <= 5000L) continue;
                Log.debug(this.getClass(), (Object)"Shrinking nio socket client connection pool...");
                pools[i].internalPool().shrinkTo(0);
            }
        }
    }
}

