/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalInputStream;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioAddress;
import org.sapia.ubik.util.ByteVector;
import org.sapia.ubik.util.ByteVectorOutputStream;

public class NioTcpRmiClientConnection
implements RmiConnection {
    static final int MAX_INCREMENT = 8000;
    private Socket _sock;
    private ServerAddress _address;
    private ByteVector _vector;
    private MarshalInputStream _mis;
    private MarshalOutputStream _mos;

    public NioTcpRmiClientConnection(Socket sock, int bufsize) throws IOException {
        this._sock = sock;
        this._address = new NioAddress(sock.getInetAddress().getHostAddress(), sock.getPort());
        this._vector = new ByteVector(bufsize, bufsize > 8000 ? 8000 : bufsize);
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._address;
    }

    @Override
    public void send(Object o, VmId vmId, String transportType) throws IOException, RemoteException {
        this._vector.clear(false);
        if (this._mos == null) {
            this._mos = new MarshalOutputStream(new ByteVectorOutputStream(this._vector));
        }
        this._mos.setUp(vmId, transportType);
        this._mos.writeObject(o);
        this._mos.flush();
        try {
            this.doSend(this._vector);
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
    }

    @Override
    public void send(Object o) throws IOException, RemoteException {
        this._vector.clear(false);
        if (this._mos == null) {
            this._mos = new MarshalOutputStream(new ByteVectorOutputStream(this._vector));
        }
        this._mos.writeObject(o);
        this._mos.flush();
        try {
            this.doSend(this._vector);
        }
        catch (SocketException e) {
            throw new RemoteException("communication with server interrupted; server probably disappeared", e);
        }
    }

    @Override
    public Object receive() throws IOException, ClassNotFoundException, RemoteException {
        try {
            if (this._mis == null) {
                this._mis = new MarshalInputStream(this._sock.getInputStream());
            }
            return this._mis.readObject();
        }
        catch (EOFException e) {
            throw new RemoteException("Communication with server interrupted; server probably disappeared", e);
        }
        catch (SocketException e) {
            throw new RemoteException("Connection could not be opened; server is probably down", e);
        }
    }

    @Override
    public void close() {
        try {
            this._sock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doSend(ByteVector vector) throws IOException {
        OutputStream sos = this._sock.getOutputStream();
        DataOutputStream dos = new DataOutputStream(sos);
        dos.writeInt(vector.length());
        vector.reset();
        vector.read(dos);
        dos.flush();
    }
}

