/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.nio.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.TransportProvider;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioServer;
import org.sapia.ubik.rmi.server.transport.nio.tcp.NioTcpClientConnectionPool;
import org.sapia.ubik.util.Localhost;

public class NioTcpTransportProvider
implements TransportProvider {
    public static final String TRANSPORT_TYPE = "tcp/nio";
    public static final String BIND_ADDRESS = "ubik.rmi.transport.nio-tcp.bind-address";
    public static final String PORT = "ubik.rmi.transport.nio-tcp.port";
    public static final String BUFFER_SIZE = "ubik.rmi.transport.nio-tcp.buffer-size";
    public static final int DEFAULT_BUFFER_SIZE = 4000;
    private int _bufsize = 4000;

    @Override
    public Connections getPoolFor(ServerAddress address) throws RemoteException {
        return NioTcpClientConnectionPool.getInstance(address, this._bufsize);
    }

    @Override
    public String getTransportType() {
        return TRANSPORT_TYPE;
    }

    @Override
    public Server newDefaultServer() throws RemoteException {
        return this.newServer(System.getProperties());
    }

    @Override
    public Server newServer(Properties props) throws RemoteException {
        InetSocketAddress addr;
        String bindAddress;
        PropUtil pu = new PropUtil().addProperties(props).addProperties(System.getProperties());
        int port = 0;
        if (props.getProperty(PORT) != null) {
            try {
                port = Integer.parseInt(props.getProperty(PORT));
            }
            catch (NumberFormatException e) {
                Log.error(this.getClass(), (Object)"Could not parse integer from property ubik.rmi.transport.nio-tcp.bind-address: ubik.rmi.transport.nio-tcp.port");
            }
        }
        if ((bindAddress = props.getProperty(BIND_ADDRESS)) != null) {
            addr = new InetSocketAddress(bindAddress, port);
        } else {
            try {
                addr = Localhost.isIpPatternDefined() ? new InetSocketAddress(Localhost.getAnyLocalAddress().getHostAddress(), port) : new InetSocketAddress(port);
            }
            catch (UnknownHostException e) {
                throw new RemoteException("Could not determine local address", e);
            }
        }
        this._bufsize = pu.getIntProperty(BUFFER_SIZE, 4000);
        int maxThreads = pu.getIntProperty("ubik.rmi.server.max-threads", 0);
        try {
            NioServer server = new NioServer(addr, this._bufsize, maxThreads);
            return server;
        }
        catch (IOException e) {
            throw new RemoteException("Could not create server", e);
        }
    }

    @Override
    public void shutdown() {
        NioTcpClientConnectionPool.shutdown();
    }
}

