/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.util.Properties;
import org.sapia.ubik.net.TcpPortSelector;
import org.sapia.ubik.net.mplex.MultiplexServerSocket;
import org.sapia.ubik.net.mplex.MultiplexSocketConnector;
import org.sapia.ubik.net.mplex.StreamSelector;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiServer;
import org.sapia.ubik.rmi.server.transport.socket.SocketTransportProvider;
import org.sapia.ubik.util.Localhost;

public class MultiplexSocketTransportProvider
extends SocketTransportProvider {
    public static final String ACCEPTOR_THREADS = "ubik.rmi.transport.mplex.acceptor-threads";
    public static final String SELECTOR_THREADS = "ubik.rmi.transport.mplex.selector-threads";
    private MultiplexServerSocket _multiplexServer;

    public MultiplexSocketConnector createSocketConnector(StreamSelector aSelector) {
        if (this._multiplexServer == null) {
            throw new IllegalStateException("Could not create a connector - no multiplex server is created");
        }
        return this._multiplexServer.createSocketConnector(aSelector);
    }

    public void removeSocketConnector(MultiplexSocketConnector anInterceptor) {
        this._multiplexServer.removeSocketConnector(anInterceptor);
    }

    @Override
    public Server newServer(Properties props) throws RemoteException {
        PropUtil pu = new PropUtil().addProperties(props).addProperties(System.getProperties());
        return this.doNewServer(pu.getIntProperty("ubik.rmi.transport.socket.port", 0), pu);
    }

    @Override
    public Server newServer(int port) throws RemoteException {
        PropUtil pu = new PropUtil().addProperties(System.getProperties());
        return this.doNewServer(port, pu);
    }

    @Override
    protected Server doNewServer(int port, PropUtil pu) throws RemoteException {
        SocketRmiServer server;
        int maxThreads = 0;
        int acceptorCount = 0;
        int selectorCount = 0;
        if (this._multiplexServer != null) {
            throw new IllegalStateException("There is already one multiplex server running: " + this._multiplexServer);
        }
        maxThreads = pu.getIntProperty("ubik.rmi.server.max-threads", 0);
        if (maxThreads == 0) {
            maxThreads = pu.getIntProperty("ubik.rmi.transport.socket.max-threads", 0);
        }
        acceptorCount = pu.getIntProperty(ACCEPTOR_THREADS, 0);
        selectorCount = pu.getIntProperty(SELECTOR_THREADS, 0);
        String bindAddress = null;
        try {
            bindAddress = pu.getProperty("ubik.rmi.transport.socket.bind-address", Localhost.getAnyLocalAddress().getHostAddress());
        }
        catch (IOException e) {
            throw new RemoteException("Invalid bind address", e);
        }
        if (port == 0) {
            try {
                port = new TcpPortSelector().select(bindAddress);
            }
            catch (IOException e) {
                throw new RemoteException("Could not acquire random port");
            }
        }
        try {
            Log.debug(this.getClass(), (Object)("Creating server on " + bindAddress + ":" + port));
            this._multiplexServer = Localhost.isIpPatternDefined() ? new MultiplexServerSocket(port, 50, InetAddress.getByName(bindAddress)) : new MultiplexServerSocket(port, 50);
            if (acceptorCount > 0) {
                this._multiplexServer.setAcceptorDaemonThread(acceptorCount);
            }
            if (selectorCount > 0) {
                this._multiplexServer.setSelectorDaemonThread(selectorCount);
            }
            server = new SocketRmiServer(maxThreads, (ServerSocket)this._multiplexServer, pu.getLongProperty("ubik.rmi.server.reset-interval", 5000L));
        }
        catch (IOException ioe) {
            throw new RemoteException("could not create multiplex server socket", ioe);
        }
        if (pu.getBooleanProperty("ubik.rmi.stats.enabled", false)) {
            server.enableStats();
        } else {
            server.disableStats();
        }
        return server;
    }
}

