/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.socket;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Hashtable;
import java.util.Map;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.ConnectionPool;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.RmiConnection;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiConnectionFactory;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;

public class SocketClientConnectionPool
implements Connections {
    private static Map _pools = new Hashtable();
    private static boolean _started;
    ConnectionPool _pool;

    public SocketClientConnectionPool(String host, int port, long resetInterval, RMIClientSocketFactory socketFactory) {
        this._pool = new ConnectionPool(host, port, new SocketRmiConnectionFactory().setResetInterval(resetInterval), socketFactory);
    }

    @Override
    public RmiConnection acquire() throws RemoteException {
        try {
            return (RmiConnection)this._pool.acquire();
        }
        catch (IOException e) {
            throw new RemoteException("Could not acquire a connection", e);
        }
    }

    @Override
    public void release(Connection conn) {
        this._pool.release(conn);
    }

    @Override
    public void clear() {
        this._pool.shrinkTo(0);
    }

    @Override
    public String getTransportType() {
        return "tcp/socket";
    }

    ConnectionPool internalPool() {
        return this._pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void shutdown() {
        if (_started) {
            Map map = _pools;
            synchronized (map) {
                for (SocketClientConnectionPool pool : _pools.values()) {
                    pool.internalPool().shrinkTo(0);
                }
            }
        }
    }

    static synchronized SocketClientConnectionPool getInstance(ServerAddress address, RMIClientSocketFactory factory, long resetInterval) {
        SocketClientConnectionPool pool;
        if (!_started) {
            _started = true;
            Hub.taskMan.addTask(new TaskContext(SocketClientConnectionPool.class.getName(), 30000L), new PoolCleaner(_pools));
        }
        if ((pool = (SocketClientConnectionPool)_pools.get(address)) == null) {
            pool = new SocketClientConnectionPool(((TCPAddress)address).getHost(), ((TCPAddress)address).getPort(), resetInterval, factory);
            _pools.put(address, pool);
        }
        return pool;
    }

    static synchronized void invalidate(TCPAddress id) {
        _pools.remove(id);
    }

    static final class PoolCleaner
    implements Task {
        static final long INTERVAL = 30000L;
        Map _pools;

        PoolCleaner(Map pools) {
            this._pools = pools;
        }

        @Override
        public void exec(TaskContext context) {
            SocketClientConnectionPool[] pools = this._pools.values().toArray(new SocketClientConnectionPool[this._pools.size()]);
            for (int i = 0; i < pools.length; ++i) {
                if (System.currentTimeMillis() - pools[i].internalPool().getLastUsageTime() <= 30000L) continue;
                Log.debug(this.getClass(), (Object)"Shrinking socket client connection pool...");
                pools[i].internalPool().shrinkTo(0);
            }
        }
    }
}

