/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.rmi.RemoteException;
import javax.management.ObjectName;
import org.sapia.ubik.jmx.MBeanContainer;
import org.sapia.ubik.jmx.MBeanFactory;
import org.sapia.ubik.net.DefaultUbikServerSocketFactory;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.SocketConnectionFactory;
import org.sapia.ubik.net.SocketServer;
import org.sapia.ubik.net.TCPAddress;
import org.sapia.ubik.net.ThreadPool;
import org.sapia.ubik.net.UbikServerSocketFactory;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiConnectionFactory;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiServerMBean;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiServerThreadPool;

public class SocketRmiServer
extends SocketServer
implements Server,
SocketRmiServerMBean,
MBeanFactory {
    private ServerAddress _addr;

    public SocketRmiServer(String bindAddr, int port, int maxThreads, long resetInterval) throws IOException {
        super(bindAddr, port, new SocketRmiConnectionFactory().setResetInterval(resetInterval), new SocketRmiServerThreadPool("ubik.rmi.server.SocketServerThread", true, maxThreads), new DefaultUbikServerSocketFactory());
        this._addr = new TCPAddress(InetAddress.getByName(bindAddr).getHostAddress(), port);
    }

    public SocketRmiServer(String bindAddr, int port, int maxThreads, long resetInterval, UbikServerSocketFactory factory) throws IOException {
        super(bindAddr, port, new SocketRmiConnectionFactory().setResetInterval(resetInterval), new SocketRmiServerThreadPool("ubik.rmi.server.SocketServerThread", true, maxThreads), factory);
        this._addr = new TCPAddress(InetAddress.getByName(bindAddr).getHostAddress(), port);
    }

    protected SocketRmiServer(ThreadPool tp, ServerSocket server, long resetInterval) throws IOException {
        super(new SocketRmiConnectionFactory().setResetInterval(resetInterval), tp, server);
        this._addr = new TCPAddress(server.getInetAddress().getHostAddress(), server.getLocalPort());
    }

    protected SocketRmiServer(int maxThreads, ServerSocket server, long resetInterval) throws IOException {
        super(new SocketRmiConnectionFactory().setResetInterval(resetInterval), (ThreadPool)new SocketRmiServerThreadPool("ubik.rmi.server.SocketServerThread", true, maxThreads), server);
        this._addr = new TCPAddress(server.getInetAddress().getHostAddress(), server.getLocalPort());
    }

    protected SocketRmiServer(SocketConnectionFactory fac, ThreadPool tp, ServerSocket server) throws IOException {
        super(fac, tp, server);
        this._addr = new TCPAddress(server.getInetAddress().getHostAddress(), server.getLocalPort());
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._addr;
    }

    @Override
    public void start() throws RemoteException {
        Hub.statsCollector.addStat(super.getRequestDurationStat());
        Hub.statsCollector.addStat(super.getRequestsPerSecondStat());
        Log.debug(this.getClass(), (Object)"starting server");
        Thread t = new Thread(this);
        t.setName("ubik.rmi.server.SocketServer");
        t.setDaemon(true);
        t.start();
        try {
            this.waitStarted();
        }
        catch (InterruptedException e) {
            RemoteException re = new RemoteException("Thread interrupted during server startup", e);
            throw re;
        }
        catch (SocketException e) {
            RemoteException re = new RemoteException("Error while starting up", e);
            throw re;
        }
    }

    @Override
    public int getThreadCount() {
        return super.getThreadCount();
    }

    @Override
    public double getRequestDurationSeconds() {
        return super.getRequestDurationStat().getStat() / 1000.0;
    }

    @Override
    public double getRequestsPerSecond() {
        return super.getRequestsPerSecondStat().getStat();
    }

    @Override
    public MBeanContainer createMBean() throws Exception {
        ObjectName name = new ObjectName("sapia.ubik.rmi:type=TcpSocketServer");
        return new MBeanContainer(name, this);
    }

    @Override
    protected boolean handleError(Throwable t) {
        Log.error(this.getClass(), (Object)t);
        return false;
    }
}

