/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.net.SocketException;
import org.sapia.ubik.net.Connection;
import org.sapia.ubik.net.PooledThread;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.rmi.server.Config;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.invocation.InvokeCommand;
import org.sapia.ubik.rmi.server.perf.PerfAnalyzer;
import org.sapia.ubik.rmi.server.perf.Topic;
import org.sapia.ubik.rmi.server.transport.RmiConnection;

public class SocketRmiServerThread
extends PooledThread {
    private Perf _perf = new Perf();
    Connection _current;

    SocketRmiServerThread() {
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this._current != null) {
            this._current.close();
        }
    }

    @Override
    protected void doExec(Object task) {
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"handling request");
        }
        Request req = (Request)task;
        this._current = req.getConnection();
        Object resp = null;
        while (true) {
            try {
                while (true) {
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)("receiving command from: " + req.getConnection().getServerAddress()));
                    }
                    RMICommand cmd = (RMICommand)req.getConnection().receive();
                    if (Log.isDebug()) {
                        Log.debug(this.getClass(), (Object)("command received: " + cmd.getClass().getName() + " from " + req.getConnection().getServerAddress() + '@' + cmd.getVmId()));
                    }
                    cmd.init(new Config(req.getServerAddress(), req.getConnection()));
                    long start = System.currentTimeMillis();
                    if (this._tps != null && this._tps.isEnabled()) {
                        this._tps.hit();
                    }
                    try {
                        if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                            this._perf.remoteCall.start();
                        }
                        resp = cmd.execute();
                        this.end(start);
                        if (this._perf.remoteCall.isEnabled() && cmd instanceof InvokeCommand) {
                            this._perf.remoteCall.end();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        t.fillInStackTrace();
                        resp = t;
                        this.end(start);
                    }
                    if (this._perf.sendResponse.isEnabled() && cmd instanceof InvokeCommand) {
                        this._perf.sendResponse.start();
                    }
                    ((RmiConnection)req.getConnection()).send(resp, cmd.getVmId(), cmd.getServerAddress().getTransportType());
                    if (!this._perf.sendResponse.isEnabled() || !(cmd instanceof InvokeCommand)) continue;
                    this._perf.sendResponse.end();
                }
            }
            catch (RuntimeException e) {
                Log.error(this.getClass(), (Object)"RuntimeException caught sending response", (Throwable)e);
                try {
                    e.fillInStackTrace();
                    req.getConnection().send(e);
                }
                catch (IOException e2) {
                    req.getConnection().close();
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                e.fillInStackTrace();
                Log.error(this.getClass(), (Object)"Class not found while receiving sending request", (Throwable)e);
                try {
                    req.getConnection().send(e);
                }
                catch (IOException e2) {
                    e2.fillInStackTrace();
                    req.getConnection().close();
                    break;
                }
            }
            catch (EOFException e) {
                e.fillInStackTrace();
                req.getConnection().close();
                break;
            }
            catch (SocketException e) {
                e.fillInStackTrace();
                req.getConnection().close();
                break;
            }
            catch (NotSerializableException e) {
                e.fillInStackTrace();
                Log.error(this.getClass().getName(), (Object)"Could not serialize class while sending response", (Throwable)e);
                try {
                    req.getConnection().send(e);
                }
                catch (IOException e2) {
                    req.getConnection().close();
                    break;
                }
            }
            catch (InvalidClassException e) {
                e.fillInStackTrace();
                Log.error(this.getClass(), (Object)"Class is invalid; object could not be sent", (Throwable)e);
                e.fillInStackTrace();
                try {
                    req.getConnection().send(e);
                }
                catch (IOException e2) {
                    req.getConnection().close();
                    break;
                }
            }
            catch (IOException e) {
                e.fillInStackTrace();
                try {
                    req.getConnection().send(e);
                }
                catch (IOException e2) {
                    req.getConnection().close();
                    break;
                }
            }
        }
    }

    @Override
    protected void handleExecutionException(Exception e) {
        Log.warning(this.getClass(), (Object)"Error executing thread", (Throwable)e);
    }

    private void end(long start) {
        if (this._duration != null && this._duration.isEnabled()) {
            this._duration.incrementLong(System.currentTimeMillis() - start);
        }
    }

    private String className() {
        return this.getClass().getName();
    }

    class Perf {
        Topic remoteCall;
        Topic sendResponse;

        Perf() {
            this.remoteCall = PerfAnalyzer.getInstance().getTopic(SocketRmiServerThread.this.className() + ".RemoteCall");
            this.sendResponse = PerfAnalyzer.getInstance().getTopic(SocketRmiServerThread.this.className() + ".SendResponse");
        }
    }
}

