/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.socket;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Properties;
import org.sapia.ubik.net.DefaultClientSocketFactory;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.TcpPortSelector;
import org.sapia.ubik.net.UbikServerSocketFactory;
import org.sapia.ubik.rmi.PropUtil;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.Connections;
import org.sapia.ubik.rmi.server.transport.TransportProvider;
import org.sapia.ubik.rmi.server.transport.socket.SocketClientConnectionPool;
import org.sapia.ubik.rmi.server.transport.socket.SocketRmiServer;
import org.sapia.ubik.util.Localhost;

public class SocketTransportProvider
implements TransportProvider {
    public static final String TRANSPORT_TYPE = "tcp/socket";
    public static final String MAX_THREADS = "ubik.rmi.transport.socket.max-threads";
    public static final String CLIENT_FACTORY = "ubik.rmi.transport.socket.client-factory";
    public static final String SERVER_FACTORY = "ubik.rmi.transport.socket.server-factory";
    public static final String BIND_ADDRESS = "ubik.rmi.transport.socket.bind-address";
    public static final String PORT = "ubik.rmi.transport.socket.port";
    public static final long DEFAULT_RESET_INTERVAL = 5000L;
    private RMIClientSocketFactory _factory;
    private long _resetInterval = -1L;

    @Override
    public synchronized Connections getPoolFor(ServerAddress address) throws RemoteException {
        if (this._factory == null) {
            if (System.getProperty(CLIENT_FACTORY) != null) {
                String name = System.getProperty(CLIENT_FACTORY);
                try {
                    this._factory = (RMIClientSocketFactory)Class.forName(name).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RemoteException("problem instantiating client socket factory", e);
                }
                catch (IllegalAccessException e) {
                    throw new RemoteException("could not find client socket factory; make sure factory class is public, and has a public, no-arg constructor", e);
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("could not find client socket factory implementation: " + name, e);
                }
            } else {
                this._factory = new DefaultClientSocketFactory();
            }
        }
        if (this._resetInterval < 0L) {
            PropUtil pu = new PropUtil().addProperties(System.getProperties());
            this._resetInterval = pu.getLongProperty("ubik.rmi.server.reset-interval", 5000L);
        }
        return SocketClientConnectionPool.getInstance(address, this._factory, this._resetInterval);
    }

    @Override
    public Server newServer(Properties props) throws RemoteException {
        PropUtil pu = new PropUtil().addProperties(props).addProperties(System.getProperties());
        return this.doNewServer(pu.getIntProperty(PORT, 0), pu);
    }

    @Override
    public Server newDefaultServer() throws RemoteException {
        PropUtil pu = new PropUtil().addProperties(System.getProperties());
        return this.doNewServer(pu.getIntProperty(PORT, 0), pu);
    }

    public Server newServer(int port) throws RemoteException {
        PropUtil pu = new PropUtil().addProperties(System.getProperties());
        return this.doNewServer(port, pu);
    }

    protected Server doNewServer(int port, PropUtil pu) throws RemoteException {
        SocketRmiServer server;
        int maxThreads = 0;
        try {
            maxThreads = pu.getIntProperty("ubik.rmi.server.max-threads", 0);
        }
        catch (NumberFormatException e) {
            Log.error(this.getClass(), (Object)"could not parse integer from property: ubik.rmi.server.max-threads");
        }
        if (maxThreads == 0) {
            maxThreads = pu.getIntProperty(MAX_THREADS, 0);
        }
        String bindAddress = null;
        try {
            bindAddress = pu.getProperty(BIND_ADDRESS, Localhost.getAnyLocalAddress().getHostAddress());
        }
        catch (IOException e) {
            throw new RemoteException("Invalid bind address", e);
        }
        if (port == 0) {
            try {
                port = new TcpPortSelector().select(bindAddress);
            }
            catch (IOException e) {
                throw new RemoteException("Could not acquire random port");
            }
        }
        if (pu.getProperty(SERVER_FACTORY) != null) {
            UbikServerSocketFactory fac;
            String name = pu.getProperty(SERVER_FACTORY);
            try {
                fac = (UbikServerSocketFactory)Class.forName(name).newInstance();
            }
            catch (InstantiationException e) {
                throw new RemoteException("problem instantiating server socket factory", e);
            }
            catch (IllegalAccessException e) {
                throw new RemoteException("could not find server socket factory; make sure factory class is public, and has a public, no-arg constructor", e);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteException("could not find server socket factory implementation: " + name, e);
            }
            try {
                server = new SocketRmiServer(bindAddress, port, maxThreads, pu.getLongProperty("ubik.rmi.server.reset-interval", 5000L), fac);
            }
            catch (IOException e) {
                throw new RemoteException("could not create server socket", e);
            }
        }
        try {
            server = new SocketRmiServer(bindAddress, port, maxThreads, pu.getLongProperty("ubik.rmi.server.reset-interval", 5000L));
        }
        catch (IOException e) {
            throw new RemoteException("could not create server socket", e);
        }
        if (pu.getBooleanProperty("ubik.rmi.stats.enabled", false)) {
            server.enableStats();
        } else {
            server.disableStats();
        }
        return server;
    }

    @Override
    public String getTransportType() {
        return TRANSPORT_TYPE;
    }

    @Override
    public void shutdown() {
        SocketClientConnectionPool.shutdown();
    }
}

