/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.udp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.rmi.RemoteException;
import org.sapia.ubik.net.udp.ObjectStreamFactory;
import org.sapia.ubik.net.udp.UDPConnection;
import org.sapia.ubik.net.udp.UDPServerAddress;
import org.sapia.ubik.rmi.server.VmId;
import org.sapia.ubik.rmi.server.transport.MarshalOutputStream;
import org.sapia.ubik.rmi.server.transport.RmiConnection;

public class UdpRmiConnection
extends UDPConnection
implements RmiConnection {
    private ObjectStreamFactory _fac = new UdpObjectStreamFactory();

    public UdpRmiConnection(UDPServerAddress addr, int bufsz, int timeout) {
        super(addr, bufsz, timeout);
    }

    public UdpRmiConnection(DatagramSocket localServer, DatagramPacket pack, int bufsz, int timeout) {
        super(localServer, pack, bufsz, timeout);
    }

    @Override
    public void send(Object o, VmId associated, String transportType) throws IOException, RemoteException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this._bufsz);
        MarshalOutputStream ous = (MarshalOutputStream)this._fac.toOutput(bos);
        ous.setUp(associated, transportType);
        ous.writeObject(o);
        ous.flush();
        ous.close();
        super.send(bos.toByteArray());
    }

    @Override
    protected ObjectStreamFactory getFactory() {
        return this._fac;
    }

    public static final class UdpObjectStreamFactory
    implements ObjectStreamFactory {
        @Override
        public ObjectOutputStream toOutput(OutputStream os) throws IOException {
            return new MarshalOutputStream(os);
        }
    }
}

