/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.rmi.server.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.sapia.ubik.net.Request;
import org.sapia.ubik.net.ServerAddress;
import org.sapia.ubik.net.udp.UDPServer;
import org.sapia.ubik.net.udp.UDPServerAddress;
import org.sapia.ubik.rmi.server.Config;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.RMICommand;
import org.sapia.ubik.rmi.server.Server;
import org.sapia.ubik.rmi.server.transport.RmiConnection;

public class UdpRmiServer
extends UDPServer
implements Server {
    public UdpRmiServer() throws SocketException {
        super(new DatagramSocket(0));
    }

    @Override
    public ServerAddress getServerAddress() {
        return new UDPServerAddress(this._server.getInetAddress(), this._server.getPort());
    }

    @Override
    public void start() {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.setName("ubik.rmi.server");
        t.start();
    }

    @Override
    protected void handleRequest(Request req, Object data) {
        Object resp;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)"receiving command");
        }
        RMICommand cmd = (RMICommand)data;
        if (Log.isDebug()) {
            Log.debug(this.getClass(), (Object)("command received: " + cmd.getClass().getName() + " from " + req.getConnection().getServerAddress() + '@' + cmd.getVmId()));
        }
        cmd.init(new Config(req.getServerAddress(), req.getConnection()));
        try {
            resp = cmd.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp = t;
        }
        try {
            ((RmiConnection)req.getConnection()).send(resp, cmd.getVmId(), cmd.getServerAddress().getTransportType());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

