/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.taskman;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;
import org.sapia.ubik.taskman.TaskManager;

public class DefaultTaskManager
implements TaskManager {
    public static long DEFAULT_MIN_DELAY = 5000L;
    private List _tasks = new ArrayList();
    private List _toAdd = Collections.synchronizedList(new ArrayList(3));
    private List _processing = new ArrayList();
    private long _nextExectime = System.currentTimeMillis();
    private long _minDelay = DEFAULT_MIN_DELAY;
    private Object _taskLock = new Object();
    private WakeupLock _timerLock = new WakeupLock();
    private Thread _taskMan;

    @Override
    public void addTask(TaskContext ctx, Task task) {
        this._toAdd.add(new TaskWrapper(ctx, task));
        this.wakeup();
    }

    @Override
    public synchronized void shutdown() {
        if (this._taskMan != null) {
            while (this._taskMan.isAlive()) {
                this._taskMan.interrupt();
                try {
                    this._taskMan.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._taskMan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTasks() {
        this._processing.clear();
        if (this._toAdd.size() > 0) {
            this._tasks.addAll(this._toAdd);
            this._toAdd.clear();
        }
        Object object = this._taskLock;
        synchronized (object) {
            this._processing.addAll(this._tasks);
        }
        for (int i = 0; i < this._processing.size(); ++i) {
            TaskWrapper tw = (TaskWrapper)this._processing.get(i);
            if (!tw.ctx.isDue()) continue;
            tw.execute();
        }
        Object object2 = this._taskLock;
        synchronized (object2) {
            this.calcNextExecTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calcNextExecTime() {
        Object object = this._taskLock;
        synchronized (object) {
            this.removeAborted();
            long tmpTime = 0L;
            for (int i = 0; i < this._tasks.size(); ++i) {
                TaskWrapper tw = (TaskWrapper)this._tasks.get(i);
                long taskNextExecTime = tw.ctx.getNextExecTime();
                if (tmpTime != 0L && taskNextExecTime >= tmpTime) continue;
                tmpTime = taskNextExecTime;
            }
            this._nextExectime = tmpTime;
        }
    }

    void removeAborted() {
        for (int i = 0; i < this._tasks.size(); ++i) {
            TaskWrapper tw = (TaskWrapper)this._tasks.get(i);
            if (!tw.ctx.isAborted()) continue;
            this._tasks.remove(i--);
        }
    }

    private synchronized void wakeup() {
        if (this._taskMan == null) {
            this._taskMan = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            long delay = DefaultTaskManager.this._nextExectime - System.currentTimeMillis();
                            if (delay < 0L) {
                                delay = 0L;
                            }
                            if (delay < DefaultTaskManager.this._minDelay) {
                                delay = DefaultTaskManager.this._minDelay;
                            }
                            DefaultTaskManager.this._timerLock.waitForTask(delay);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        DefaultTaskManager.this.processTasks();
                    }
                }
            }, "Ubik.TaskManager");
            this._taskMan.setDaemon(true);
            this._taskMan.start();
        }
        this._timerLock.wakeup();
    }

    static class WakeupLock {
        boolean wakeup = false;

        WakeupLock() {
        }

        synchronized void waitForTask(long timeout) throws InterruptedException {
            if (!this.wakeup && timeout != 0L) {
                super.wait(timeout);
            }
            this.wakeup = false;
        }

        synchronized void wakeup() {
            this.wakeup = true;
            super.notify();
        }
    }

    static class TaskWrapper {
        private TaskContext ctx;
        private Task task;

        TaskWrapper(TaskContext ctx, Task task) {
            this.ctx = ctx;
            this.task = task;
        }

        long execute() {
            try {
                this.task.exec(this.ctx);
            }
            catch (RuntimeException e) {
                Log.error(DefaultTaskManager.class.getName(), (Object)e);
            }
            return this.ctx.calcNextExecTime();
        }
    }
}

