/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.taskman;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sapia.ubik.rmi.server.Hub;
import org.sapia.ubik.rmi.server.Log;
import org.sapia.ubik.rmi.server.perf.HitStatFactory;
import org.sapia.ubik.rmi.server.perf.HitsPerMinStatistic;
import org.sapia.ubik.taskman.Task;
import org.sapia.ubik.taskman.TaskContext;
import org.sapia.ubik.taskman.TaskManager;

public class MultithreadedTaskManager
implements TaskManager {
    private List _threads = Collections.synchronizedList(new ArrayList());

    @Override
    public void addTask(final TaskContext ctx, final Task task) {
        final HitsPerMinStatistic stat = HitStatFactory.createHitsPerMin("TaskManager." + ctx.getName(), ctx.getInterval(), Hub.statsCollector);
        Thread taskThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    do {
                        try {
                            Thread.sleep(ctx.getInterval());
                            task.exec(ctx);
                            stat.hit();
                        }
                        catch (InterruptedException e) {
                            Log.warning(this.getClass(), (Object)"Interrupted...");
                            break block3;
                        }
                    } while (!Thread.interrupted() && !ctx.isAborted());
                    MultithreadedTaskManager.this._threads.remove(Thread.currentThread());
                }
            }
        }, task.getClass().getName());
        taskThread.setDaemon(true);
        taskThread.start();
        this._threads.add(taskThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        List list = this._threads;
        synchronized (list) {
            for (int i = 0; i < this._threads.size(); ++i) {
                Thread t = (Thread)this._threads.get(i);
                t.interrupt();
                for (int count = 0; t.isAlive() && count < 3; ++count) {
                    try {
                        t.join(1000L);
                        t.interrupt();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }
}

