/*
 * Decompiled with CFR 0.152.
 */
package org.sapia.ubik.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteVector {
    public static final int DEFAULT_ARRAY_CAPACITY = 200;
    public static final int DEFAULT_INCREMENT = 10;
    protected int _arrayPos;
    protected int _markPos;
    protected int _markOffset;
    protected int _arrayCount;
    protected int _capacity = 200;
    protected int _increment = 10;
    protected ByteArray[] _arrays = new ByteArray[this._increment];

    public ByteVector() {
    }

    public ByteVector(int capacity, int increment) {
        this._capacity = capacity;
        this._increment = increment;
    }

    public void mark(int mark) {
        if (mark < this._capacity) {
            this._markPos = 0;
            this._markOffset = mark;
        } else {
            int pos = mark / this._capacity;
            int offset = mark % this._capacity;
            if (pos >= this._arrayCount) {
                throw new IndexOutOfBoundsException("" + mark);
            }
            this._markPos = pos;
            this._markOffset = offset;
        }
    }

    public void reset() {
        this._arrayPos = this._markPos;
        this._arrays[this._arrayPos]._pos = this._markOffset;
        for (int i = this._arrayPos + 1; i < this._arrayCount; ++i) {
            this._arrays[i]._pos = 0;
        }
    }

    public void clear(boolean freeMemory) {
        this._arrayPos = 0;
        this._markOffset = 0;
        this._markPos = 0;
        if (freeMemory) {
            this._arrays = new ByteArray[this._increment];
        } else {
            for (int i = 0; i < this._arrayCount; ++i) {
                this._arrays[i]._pos = 0;
                this._arrays[i]._limit = 0;
            }
        }
        this._arrayCount = 0;
    }

    public int length() {
        if (this._arrayCount == 0) {
            return 0;
        }
        return (this._arrayCount - 1) * this._capacity + this._arrays[this._arrayCount - 1]._limit;
    }

    public int position() {
        if (this._arrayCount == 0) {
            return 0;
        }
        if (this._arrayPos == 0) {
            return this._arrays[this._arrayPos]._pos;
        }
        if (this._arrayPos >= this._arrayCount) {
            return (this._arrayCount - 1) * this._capacity + this._arrays[this._arrayCount - 1]._pos;
        }
        return this._arrayPos * this._capacity + this._arrays[this._arrayPos]._pos;
    }

    public int remaining() {
        return this.length() - this.position();
    }

    int arrayPosition() {
        return this._arrayPos;
    }

    int arrayCount() {
        return this._arrayCount;
    }

    public boolean hasRemaining() {
        return this._arrayPos < this._arrayCount && this._arrays[this._arrayPos]._pos < this._arrays[this._arrayPos]._limit;
    }

    public byte[] toByteArray() {
        if (this._arrayCount == 0 || this._arrays[0] == null) {
            return new byte[0];
        }
        byte[] b = new byte[this.length()];
        int index = 0;
        for (int i = this._arrayPos; i < this._arrayCount; ++i) {
            for (int j = 0; j < this._arrays[i]._limit; ++j) {
                b[index] = this._arrays[i]._bytes[j];
                ++index;
            }
        }
        return b;
    }

    public int read() {
        if (this._arrayCount == 0 || this._arrayPos >= this._arrayCount) {
            return -1;
        }
        ByteArray arr = this._arrays[this._arrayPos];
        if (arr == null) {
            return -1;
        }
        if (arr._pos < arr._limit) {
            int b = arr._bytes[arr._pos++] & 0xFF;
            if (arr._pos >= arr._limit) {
                ++this._arrayPos;
            }
            return b;
        }
        return -1;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        int read = 0;
        int total = 0;
        while (len > 0 && this._arrayPos < this._arrayCount && (read = this._arrays[this._arrayPos].get(b, off, len)) != 0) {
            if (this._arrays[this._arrayPos]._pos >= this._arrays[this._arrayPos]._limit) {
                ++this._arrayPos;
            }
            len -= read;
            off += read;
            total += read;
        }
        return total;
    }

    public int read(ByteBuffer buf) {
        int read = 0;
        int total = 0;
        int len = buf.remaining();
        while (len > 0 && this._arrayPos < this._arrayCount && (read = this._arrays[this._arrayPos].get(buf, len)) != 0) {
            if (this._arrays[this._arrayPos]._pos >= this._arrays[this._arrayPos]._limit) {
                ++this._arrayPos;
            }
            len -= read;
            total += read;
        }
        return total;
    }

    public void read(OutputStream out) throws IOException {
        int read;
        while (this._arrayPos < this._arrayCount && (read = this._arrays[this._arrayPos].get(out)) != 0) {
            if (this._arrays[this._arrayPos]._pos < this._arrays[this._arrayPos]._limit) continue;
            ++this._arrayPos;
        }
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(int b) {
        if (this._arrayPos >= this._arrayCount) {
            this.increase();
        }
        if (!this._arrays[this._arrayPos++].put((byte)b)) {
            this.increase();
            this._arrays[this._arrayPos - 1].put((byte)b);
        }
    }

    public void write(byte[] b, int off, int len) {
        int put = 0;
        while (put < len) {
            if (this._arrayPos >= this._arrayCount) {
                this.increase();
            }
            if ((put = this._arrays[this._arrayPos].put(b, off, len)) < len) {
                ++this._arrayPos;
            }
            off += put;
            len -= put;
            put = 0;
        }
    }

    public void write(ByteBuffer buf) {
        while (buf.hasRemaining()) {
            if (this._arrayPos >= this._arrayCount) {
                this.increase();
            }
            int len = buf.remaining();
            int put = this._arrays[this._arrayPos].put(buf);
            if (put < len) {
                ++this._arrayPos;
            }
            boolean bl = false;
        }
    }

    public long skip(long skip) {
        int size;
        ByteArray arr;
        if (this._arrayCount == 0) {
            return 0L;
        }
        long total = 0L;
        while (total < skip && this._arrayPos < this._arrayCount && (arr = this._arrays[this._arrayPos]) != null && (size = arr._limit - arr._pos) > 0) {
            if (total + (long)size <= skip) {
                arr._pos = arr._limit;
                total += (long)size;
                ++this._arrayPos;
                continue;
            }
            size = (int)(skip - total);
            arr._pos += size;
            total += (long)size;
        }
        return total;
    }

    private void increase() {
        if (this._arrayPos >= this._arrays.length) {
            ByteArray[] newArray = new ByteArray[this._arrays.length + this._increment];
            System.arraycopy(this._arrays, 0, newArray, 0, this._arrays.length);
            this._arrays = newArray;
        }
        if (this._arrays[this._arrayPos] == null) {
            this._arrays[this._arrayPos] = new ByteArray(this._capacity);
        }
        ++this._arrayCount;
    }

    protected static class ByteArray {
        protected int _pos;
        protected int _limit;
        protected byte[] _bytes;

        protected ByteArray(int capacity) {
            this._bytes = new byte[capacity];
        }

        protected boolean put(byte b) {
            if (this._pos < this._bytes.length) {
                this._bytes[this._pos++] = b;
                ++this._limit;
            }
            return false;
        }

        protected int put(byte[] b, int offset, int len) {
            if (this._pos < this._bytes.length) {
                if (len <= this._bytes.length - this._pos) {
                    System.arraycopy(b, offset, this._bytes, this._pos, len);
                    this._pos += len;
                    this._limit += len;
                    return len;
                }
                System.arraycopy(b, offset, this._bytes, this._pos, this._bytes.length - this._pos);
                int put = this._bytes.length - this._pos;
                this._pos += put;
                this._limit += put;
                return put;
            }
            return 0;
        }

        protected int put(ByteBuffer buf) {
            if (this._pos < this._bytes.length) {
                if (buf.remaining() <= this._bytes.length - this._pos) {
                    int len = buf.remaining();
                    buf.get(this._bytes, this._pos, buf.remaining());
                    this._pos += len;
                    this._limit += len;
                    return len;
                }
                buf.get(this._bytes, this._pos, this._bytes.length - this._pos);
                int put = this._bytes.length - this._pos;
                this._pos += put;
                this._limit += put;
                return put;
            }
            return 0;
        }

        protected int get(byte[] b, int offset, int len) {
            if (this._pos < this._limit) {
                if (this._limit - this._pos <= len) {
                    System.arraycopy(this._bytes, this._pos, b, offset, this._limit - this._pos);
                    int read = this._limit - this._pos;
                    this._pos += read;
                    return read;
                }
                System.arraycopy(this._bytes, this._pos, b, offset, len);
                this._pos += len;
                return len;
            }
            return 0;
        }

        protected int get(ByteBuffer buf, int len) {
            if (this._pos < this._limit) {
                if (this._limit - this._pos <= len) {
                    buf.put(this._bytes, this._pos, this._limit - this._pos);
                    int read = this._limit - this._pos;
                    this._pos += read;
                    return read;
                }
                buf.put(this._bytes, this._pos, len);
                this._pos += len;
                return len;
            }
            return 0;
        }

        protected int get(OutputStream out) throws IOException {
            if (this._pos >= this._limit) {
                return 0;
            }
            out.write(this._bytes, this._pos, this._limit);
            int read = this._limit - this._pos;
            this._pos += read;
            return read;
        }
    }
}

